/*************************************************
* Skipjack Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SKIPJACK_H__
#define OPENCL_SKIPJACK_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Skipjack : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw();
      std::string name() const { return "Skipjack"; }
      BlockCipher* clone() const { return new Skipjack; }
      Skipjack() : BlockCipher(8, 10) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void step_A(u16bit&, u16bit&, u32bit) const;
      void step_B(u16bit&, u16bit&, u32bit) const;
      void step_Ai(u16bit&, u16bit&, u32bit) const;
      void step_Bi(u16bit&, u16bit&, u32bit) const;
      static const byte F[256];
      SecureBuffer<byte, 256> FTABLE[10];
   };

}

#endif
