/*************************************************
* Square Header File                             *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SQUARE_H__
#define OPENCL_SQUARE_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Square : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 16;

      void clear() throw();
      std::string name() const { return "Square"; }
      BlockCipher* clone() const { return new Square; }
      Square() : BlockCipher(16, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static void transform(u32bit[4]);
      static byte mul(byte, byte);
      static const byte SE[256], SD[256], Log[256], ALog[255];
      static const u32bit TE0[256], TE1[256], TE2[256], TE3[256],
                          TD0[256], TD1[256], TD2[256], TD3[256];

      SecureBuffer<u32bit, 28> EK, DK;
      SecureBuffer<byte, 32> ME, MD;
   };

}

#endif
