/*************************************************
* TEA Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_TEA_H__
#define OPENCL_TEA_H__

#include <opencl/opencl.h>

namespace OpenCL {

class TEA : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw() { K.clear(); }
      std::string name() const { return "TEA"; }
      BlockCipher* clone() const { return new TEA; }
      TEA() : BlockCipher(8, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static const u32bit ROUNDS = 32, DELTA = 0x9E3779B9;
      SecureBuffer<u32bit, 4> K;
   };

}

#endif
