/*************************************************
* ThreeWay Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_THREEWAY_H__
#define OPENCL_THREEWAY_H__

#include <opencl/opencl.h>

namespace OpenCL {

class ThreeWay : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 12;

      void clear() throw() { EK.clear(); DK.clear(); }
      std::string name() const { return "ThreeWay"; }
      BlockCipher* clone() const { return new ThreeWay; }
      ThreeWay() : BlockCipher(12, 12) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static void mu(u32bit&, u32bit&, u32bit&);
      static void theta(u32bit&, u32bit&, u32bit&);
      static void pi_gamma_pi(u32bit&, u32bit&, u32bit&);
      SecureBuffer<u32bit, 36> EK, DK;
   };

}

#endif
