/*************************************************
* Tiger Header File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_TIGER_H__
#define OPENCL_TIGER_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Tiger : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 24;

      void clear() throw();
      std::string name() const { return "Tiger"; }
      HashFunction* clone() const { return new Tiger; }
      Tiger() : HashFunction(24, 64) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static void round(u64bit&, u64bit&, u64bit&, u64bit, u32bit);
      static const u64bit SBOX1[256], SBOX2[256], SBOX3[256], SBOX4[256];
      SecureBuffer<byte, 64> buffer;
      SecureBuffer<u64bit, 8> X;
      SecureBuffer<u64bit, 3> digest;
      u64bit count, position;
   };

}

#endif
