/*************************************************
* Timestamp Functions Header File                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_TIMERS_H__
#define OPENCL_TIMERS_H__

#include <opencl/config.h>

namespace OpenCL {

/*************************************************
* Timer Base Class                               *
*************************************************/
class Timer
   {
   public:
      virtual u64bit clock() const = 0;
      virtual ~Timer() {}
   };

/*************************************************
* Timer Access Functions                         *
*************************************************/
u64bit system_time();
u64bit system_clock();

/*************************************************
* Timer Control Functions                        *
*************************************************/
void set_timer_type(Timer*);

}

#endif
