/*************************************************
* Twofish Header File                            *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_TWOFISH_H__
#define OPENCL_TWOFISH_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Twofish : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 16;

      void clear() throw();
      std::string name() const { return "Twofish"; }
      BlockCipher* clone() const { return new Twofish; }
      Twofish() : BlockCipher(16, 16, 32, 8) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void encrypt_round(u32bit, u32bit, u32bit&, u32bit&, u32bit) const;
      void decrypt_round(u32bit, u32bit, u32bit&, u32bit&, u32bit) const;
      static void rs_mul(byte[4], byte, byte, byte, byte, byte);
      static const u32bit MDS0[256], MDS1[256], MDS2[256], MDS3[256];
      static const byte Q0[256], Q1[256], RS[32];
      static const byte EXP_TO_POLY[255], POLY_TO_EXP[255];
      SecureBuffer<u32bit, 256> SBox0, SBox1, SBox2, SBox3;
      SecureBuffer<u32bit, 40> round_key;
   };

}

#endif
