/*************************************************
* ANSI X9.17 RNG Header File                     *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ANSI_X917_RNG_H__
#define OPENCL_ANSI_X917_RNG_H__

#include <opencl/opencl.h>

namespace OpenCL {

class ANSI_X917_RNG : public RandomNumberGenerator
   {
   public:
      byte random();
      void randomize(byte[], u32bit);
      void clear() throw();
      std::string name() const;
      ANSI_X917_RNG(BlockCipher*, u32bit = 16);
      ~ANSI_X917_RNG() { delete cipher; }
   private:
      void add_randomness(const byte[], u32bit) throw();
      void generate(u64bit);
      void reseed();
      const u32bit ITERATIONS_BEFORE_RESEED, MAX_OUT_PER_BUFFER;
      BlockCipher* cipher;
      SecureVector<byte> buffer, state, tstamp;
      u32bit position, iteration;
   };

// DEPRECATED ALIAS
typedef ANSI_X917_RNG X917_RNG;

}

#endif
