/*************************************************
* ANSI X9.19 MAC Header File                     *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ANSI_X919_MAC_H__
#define OPENCL_ANSI_X919_MAC_H__

#include <opencl/des.h>

namespace OpenCL {

class ANSI_X919_MAC : public MessageAuthenticationCode
   {
   public:
      void clear() throw();
      std::string name() const { return "ANSI X9.19 MAC"; }
      MessageAuthenticationCode* clone() const { return new ANSI_X919_MAC; }
      ANSI_X919_MAC();
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void key(const byte[], u32bit);
      DES e, d;
      SecureBuffer<byte, 8> state;
      u32bit position;
   };

}

#endif
