""" Hashes -- Wrapped hash functions defined in SSLeay

    (c) Marc-Andre Lemburg; All Rights Reserved; mailto: mal@lemburg.com
    See the documentation for further copyright information or contact
    the author.
"""
# Load C interface

from Crypto import mxCrypto

# Constants

DEFAULT_DATA = ''

# Helpers
def _NOP(*args):
    pass

def _NotSupported(*args):
    raise TypeError,'method not supported'

class Hash:

    digestsize = mxCrypto.Hash_digestsize

    C_new = mxCrypto.new_Hash
    C_delete = mxCrypto.delete_Hash
    C_digest = mxCrypto.Hash_digest
    C_hexdigest = mxCrypto.Hash_hexdigest
    C_update = mxCrypto.Hash_update
    C_getstate = mxCrypto.Hash_getstate
    C_setstate = mxCrypto.Hash_setstate

    def __init__(self,data=DEFAULT_DATA):

        self.instance = self.C_new(data)

    def __del__(self):
        
        if self.instance:
            self.C_delete(self.instance)

    def __getattr__(self,name):

        if name == "digestsize":
            return self.C_digestsize_get(self.instance)
        raise AttributeError,name

    def copy(self):

        o = self.__class__()
        o.C_setstate(o.instance,self.C_getstate(self.instance))
        return o

    def digest(self):

        return self.C_digest(self.instance)

    def hexdigest(self):

        return self.C_hexdigest(self.instance)

    def update(self,data):

        return self.C_update(self.instance,data)

class MD2(Hash):

    digestsize = mxCrypto.MD2Hash_digestsize

    C_new = mxCrypto.new_MD2Hash
    C_digest = mxCrypto.MD2Hash_digest
    C_update = mxCrypto.MD2Hash_update
    C_getstate = mxCrypto.MD2Hash_getstate
    C_setstate = mxCrypto.MD2Hash_setstate

class MD5(Hash):

    digestsize = mxCrypto.MD5Hash_digestsize

    C_new = mxCrypto.new_MD5Hash
    C_digest = mxCrypto.MD5Hash_digest
    C_update = mxCrypto.MD5Hash_update
    C_getstate = mxCrypto.MD5Hash_getstate
    C_setstate = mxCrypto.MD5Hash_setstate

class SHA(Hash):

    digestsize = mxCrypto.SHAHash_digestsize

    C_new = mxCrypto.new_SHAHash
    C_digest = mxCrypto.SHAHash_digest
    C_update = mxCrypto.SHAHash_update
    C_getstate = mxCrypto.SHAHash_getstate
    C_setstate = mxCrypto.SHAHash_setstate

class RIPEMD(Hash):

    digestsize = mxCrypto.RIPEMDHash_digestsize

    C_new = mxCrypto.new_RIPEMDHash
    C_digest = mxCrypto.RIPEMDHash_digest
    C_update = mxCrypto.RIPEMDHash_update
    C_getstate = mxCrypto.RIPEMDHash_getstate
    C_setstate = mxCrypto.RIPEMDHash_setstate

