#
# saint_custom_form.pl
#
# Make HTML form for custom scan level
#
# by Sam Kline, SAINT Corp., 10/00
#

require 'perl/config.pl';

my($rnd) = time();
my($return_to, $junk) = split(/,/, $html_script_args);

@core= ("rpc.saint",
	"ddos.saint",
	"adore.saint",
	"dns.saint",
	"ostype.saint",
	"tcpscan.saint",
	"udpscan.saint"
       );

$custom_level =~ s/\W//g;

# Don't let them modify the built-in attack levels
$custom_level = "custom_" . $custom_level
	if $custom_level =~ /^(light|normal|heavy|heavyplus|top20)$/;

if ($reset_on) {
    @$custom_level = @$reset_level;
    &write_custom();
}
$reset_on = 0;
%selected = ();
$selected{$reset_level} = "selected";

%on = ();
for (@$custom_level) {
    if (/(.*)\.saint/) {
	$probe = $1 . "_saint";
	$on{$probe} = "checked";
    }
    if (/\*\?/) {
	$on{'all'} = "checked";
    }
    if (/(tcp|udp)scan\.saint\s+([\w\s,-]+)/) {
	$ports = $1 . "_ports";
	$$ports = $2;
    }
}
print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>Custom Scan Configuration</TITLE>
<LINK REV="made" HREF="mailto:saint\@saintcorporation.com">
</HEAD>
<BODY BGCOLOR="white" vlink="#000000" link="#04289D">

<P></P>

<P>
<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0">
	<TR>
		<TD COLSPAN="2"><IMG SRC="$HTML_ROOT/images/config_mgmt_banner.gif" WIDTH="621" HEIGHT="106" ALIGN="BOTTOM" ALT="Configuration Management" BORDER="0"></TD>
	</TR>
	<TR>
	  <TD WIDTH="86" VALIGN="TOP">
	    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0">
		<TR>
		    <TD WIDTH="86"><A HREF="http://www.saintcorporation.com"><IMG SRC="$HTML_ROOT/images/home.gif" WIDTH="86" HEIGHT="55" ALIGN="BOTTOM" ALT="SAINT Corporation"
			BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_ROOT/saint.html"><IMG SRC="$HTML_ROOT/images/home_button.gif" WIDTH="86" HEIGHT="46"
			ALIGN="BOTTOM" ALT="SAINT Home" BORDER="0" STYLE="Background-Image : none"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/data/saint_data_form.pl"><IMG SRC="$HTML_ROOT/images/data_mgmt_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Data Management" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/running/saint_run_form.pl,,$rnd"><IMG SRC="$HTML_ROOT/images/target_selection_button.gif"
			WIDTH="86" HEIGHT="46" ALIGN="BOTTOM" ALT="Target Selection" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/reporting/analysis.pl"><IMG SRC="$HTML_ROOT/images/data_analysis_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Data Analysis" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/admin/saint_cf_form.pl,,$rnd"><IMG SRC="$HTML_ROOT/images/config_mgmt_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Configuration Management" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_ROOT/saint_documentation.html"><IMG SRC="$HTML_ROOT/images/documentation_button.gif"
			WIDTH="86" HEIGHT="46" ALIGN="BOTTOM" ALT="SAINT Documentation" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86" HEIGHT="46"><A HREF="$HTML_ROOT/docs/FAQ.html#trouble"><IMG SRC="$HTML_ROOT/images/troubleshooting_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Troubleshooting" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86" HEIGHT="65"><IMG SRC="$HTML_ROOT/images/bottom_border.gif" WIDTH="86" HEIGHT="75" ALIGN="BOTTOM" ALT="--------" BORDER="0"></TD>
		</TR>
	    </TABLE>
	  </TD>
	  <TD VALIGN="TOP">
		<DL>
			<P>
		</DL>
<H2>Scan level: $custom_level</H2>
<FORM METHOD=POST ACTION=saint_custom_form.pl,$return_to>
Reset current scan level to a default level.
<P><SELECT NAME=reset_level>
<OPTION VALUE=light $selected{'light'}>light</OPTION>
<OPTION VALUE=normal $selected{'normal'}>normal</OPTION>
<OPTION VALUE=heavy $selected{'heavy'}>heavy</OPTION>
<OPTION VALUE=heavyplus $selected{'heavyplus'}>heavy+</OPTION>
<OPTION VALUE=top20 $selected{'top20'}>top 20</OPTION>
</SELECT>
<INPUT TYPE=HIDDEN NAME=reset_on VALUE=1>
<INPUT TYPE=SUBMIT VALUE="Reset">
</FORM>

<FORM METHOD=POST ACTION=saint_custom_action.pl,$return_to>
<H2>Core probes</H2>
The selected probes run against all targets.
<I>Disabling some of these probes may cause conditional probes
not to run.</I>
<P>
EOF
;
for (@core) {
    if (/(.*)\.saint/) {
	$probename = $1;
	$probe = $1 . "_saint";
	print CLIENT "<INPUT TYPE=checkbox NAME=\"$probe\" $on{$probe}> $probename\n<BR>";
	if ($probename =~ /(tcp|udp)scan/) {
	    $proto = uc $1;
	    $ports = $1 . "_ports";
	    print CLIENT "<BLOCKQUOTE>$proto Ports:<BR>";
	    print CLIENT "<TEXTAREA NAME=\"$ports\" ROWS=3 COLS=40 WRAP=\"virtual\">$$ports</TEXTAREA></BLOCKQUOTE>\n";
	}
    }
}

print CLIENT <<EOF
<H2>Conditional probes</H2>
These probes run based on the results of core probes or other
conditional probes.
<P>
EOF
;
while (<bin/*>) {
    if (/bin\/(.*)\.saint/) {
	$probename = $1;
	$probe = $1 . "_saint";
	if (grep(/^$1\.saint$/, @core) == 0) {
	    $on{$probe} = $on{'all'} if $on{'all'};
	    print CLIENT "<INPUT TYPE=checkbox NAME=${probe}q $on{$probe}> $probename<BR>\n";
	}
    }
}
print CLIENT <<EOF
<P><INPUT TYPE=SUBMIT VALUE="Change the configuration file">
	  </TD>
	</TR>
</TABLE>
</BODY>
</HTML>
EOF
