#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
#
#

use strict;

my $myurl="saint_exclusion_change_options.pl";

generate_html_header(\*::CLIENT,"SAINT Exclusion Options Changed");

print ::CLIENT<<EOF;
<H1><Center>Exclusion Options Change Results Page</Center></H1>
<HR>
EOF

my $changed_vis=undef;
my $changed_as=undef;
my $changed_sf=undef;

#Change display_ignored if needed
if ( $Exclusions::tmpvis eq "yes" && ! $Exclusions::display_ignored )
{	$changed_vis=1;
	$Exclusions::display_ignored = 1;
} elsif  ( $Exclusions::tmpvis eq "no" &&  $Exclusions::display_ignored )
{	$changed_vis=1;
	$Exclusions::display_ignored = 0;
}

#Change autosave if needed
if ( $Exclusions::tmpas eq "yes" && ! $Exclusions::autosave )
{	$changed_as=1;
	$Exclusions::autosave = 1;
} elsif  ( $Exclusions::tmpas eq "no" &&  $Exclusions::autosave )
{	$changed_as=1;
	$Exclusions::autosave = 0;
}


#Change savefile if needed
if ( $Exclusions::tmpsavfil ne $Exclusions::savefile )
{	$changed_sf=1;
	$Exclusions::savefile=$Exclusions::tmpsavfil;
}

my $bad_as=undef;
#Check that have valid savefile if autosav is on
if ( $Exclusions::autosave && ! $Exclusions::savefile )
{	$bad_as=1;
	$Exclusions::autosave=0;
}

my ($status_di,$status_as,$status_sf);

if ( $Exclusions::display_ignored )
{	$status_di="Currently, excluded vulnerabilies will be displayed.";
} else
{	$status_di="Currently, excluded vulnerabilies will NOT be displayed.";
}

if ( $Exclusions::autosave )
{	$status_as="Currently, changes to exclusions list will automatically be saved.";
} else
{	$status_as="Currently, changes to exclusions list must be manually saved.";
}

if ( $Exclusions::savefile )
{	$status_sf="Currently, exclusions are being saved to <code>$Exclusions::savefile</code>.";
} else
{	$status_sf="Currently there is no file to save exclusions to.";
}

my $changetxt=undef;
if ( $changed_vis )
{	$changetxt="<li>Exclusion visibility has been changed.\n";
}
if ( $changed_as )
{	if ( $bad_as )
	{   $changetxt.=<<EOF;
<li><strong>Invalid savefile with autosave</strong>.  Autosave feature has been
turned off.  Fix problem with savefile before trying to re-enable.
EOF
	} else
	{   $changetxt.="<li>Autosave of exclusions list has been toggled.\n";
	}
}
if ($changed_sf )
{	$changetxt.="<li>Savefile has been changed.\n";
}

if (! $changetxt )
{	$changetxt="<li>No changes were requested, so nothing has been changed.\n";
}

print ::CLIENT <<EOF;
<h3>Changes made</h3>
<ul>
$changetxt
</ul>
<p>
<h3>Current status</h3>
<ul>
	<li>$status_di
	<li>$status_as
	<li>$status_sf
</ul>
<hr>
<a href="saint_exclusion_manage_form.pl">Return to the Exclusion Management Form</a><br>
<a href="analysis.pl">Return to the Main Analysis Page</a><br>
<a href="../saint.html">Return to the Main SAINT Page</a><br>
EOF

&generate_html_footer(\*::CLIENT);
