#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
# Print details on a given exclusion
#

use strict;

my $myurl="saint_exclusion_detail.pl";

generate_html_header(\*::CLIENT,"Exclusion Detail Listing");

print ::CLIENT<<EOF;
<H1><Center>Detailed Listing of an Exclusion</Center></H1>
<HR>
EOF

use strict;

require "perl/exclusions.pl";


#Prints detail of this record
my ($rec) = split(/,/, $::html_script_args,1);

my $exc=decode_url_arg($rec);

my @exc = split_exclusion($exc);
if ( scalar(@exc)==0 )
{	warn "Mal-formed exclusion $exc in saint_exclusion_detail.pl";
	print ::CLIENT<<EOF;
<h2> MAlformed exclusion error</h2>
The exclusion you tried to get a detailed listing of<br>
<code>$exc</code>
is not in the proper format.  This is likely due to a bug in the
exclusion handling code.  Please contact the software maintainers.
EOF
	&generate_html_footer(\*::CLIENT);
	return;
}


my ($target, $service, $status, $severity, $trustee, $trusted, $service_output,
	$text, $version) = @exc;

print ::CLIENT<<EOF;
<p>
<dl>
<dt>Excluded Host:</dt><dd>'$target'</dd>
<dt>Service:</dt><dd>'$service'</dd>
<dt>Status:</dt><dd>'$status'</dd>
<dt>Severity:</dt><dd>'$severity'</dd>
<dt>Trustee:</dt><dd>'$trustee'</dd>
<dt>Trusted:</dt><dd>'$trusted'</dd>
<dt>Service Output:</dt><dd>'$service_output'</dd>
<dt>Text:</dt><dd>'$text'</dd>
<dt>Version:</dt><dd>'$version'</dd>
</dl>
<HR>
<ul>
<li><a href="saint_exclusion_edit_form.pl,$rec">Edit this record</a>
<li><a href="saint_exclusion_list.pl">Return to list of exclusions</a>
<li><a href="saint_exclusion_manage_form.pl">Go to exclusion management page</a>
<li><a href="analysis.pl">Go to main analysis page</a>
</ul>
EOF

&generate_html_footer(\*::CLIENT);
