#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
# Edits a given exclusion
#

use strict;

my $myurl="saint_exclusion_edit_form.pl";

generate_html_header(\*::CLIENT,"Exclusion Editor");

print ::CLIENT<<EOF;
<H1><Center>Edit an Exclusion</Center></H1>
<HR>
EOF

use strict;

require "perl/exclusions.pl";


#Prints detail of this record
my ($rec) = split(/,/, $::html_script_args,1);

my $exc=decode_url_arg($rec);

my @exc = split_exclusion($exc);
if ( scalar(@exc)==0 )
{	warn "Mal-formed exclusion $exc in saint_exclusion_detail.pl";
	print ::CLIENT<<EOF;
<h2> Malformed exclusion error</h2>
The exclusion you tried to edit<br>
<code>$exc</code>
is not in the proper format.  This is likely due to a bug in the
exclusion handling code.  Please contact the software maintainers.
EOF
	return;
}


my ($target, $service, $status, $severity, $trustee, $trusted, $service_output,
	$text, $version) = @exc;

print ::CLIENT<<EOF;
<p>
<form method=POST action="saint_exclusion_edit.pl,$rec">

<table border="0%" width="100%">
<tr>
<td><strong>Field</strong></td>
<td><strong>Original Value</strong></td>
<td><strong>Change to</strong></td>
</tr>

<tr>
<td>Target:</td>
<td>$target</td>
<td><input type="TEXT" name="Exclusions::newtarget" value="$target"></td>
</tr>

<tr>
<td>Service:</td>
<td>$service</td>
<td><input type="TEXT" name="Exclusions::newservice" value="$service"></td>
</tr>

<tr>
<td>Status:</td>
<td>$status</td>
<td><input type="TEXT" name="Exclusions::newstatus" value="$status"></td>
</tr>

<tr>
<td>Severity:</td>
<td>$severity</td>
<td><input type="TEXT" name="Exclusions::newseverity" value="$severity"></td>
</tr>

<tr>
<td>Trustee:</td>
<td>$trustee</td>
<td><input type="TEXT" name="Exclusions::newtrustee" value="$trustee"></td>
</tr>

<tr>
<td>Trusted:</td>
<td>$trusted</td>
<td><input type="TEXT" name="Exclusions::newtrusted" value="$trusted"></td>
</tr>

<tr>
<td>Service_output:</td>
<td>$service_output</td>
<td><input type="TEXT" name="Exclusions::newservice_output" value="$service_output"></td>
</tr>

<tr>
<td>Text:</td>
<td>$text</td>
<td><input type="TEXT" name="Exclusions::newtext" value="$text"></td>
</tr>

<tr>
<td>Version:</td>
<td>$version</td>
<td><input type="TEXT" name="Exclusions::newversion" value="$version"></td>
</tr>

</table>
<ul>
<li>
<INPUT TYPE="RADIO" VALUE="change" NAME="Exclusions::editmode" checked>
Replace original exclusion with modified one.
<li>
<INPUT TYPE="RADIO" VALUE="new" NAME="Exclusions::editmode">
Keep original exclusion and create new one with changed values.
</ul>

<HR>
<input type="submit" value="Make changes">
</form>
<BR>
<A HREF="really_unexclude_it.pl,E,$rec,saint_exclusion_list.pl">
Delete original exclusion</A>
<P>
<HR>
EOF

&generate_html_footer(\*::CLIENT);
