#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
#
#

use strict;

my $myurl="saint_exclusion_list.pl";

generate_html_header(\*::CLIENT,"List of Excluded Vulnerabilities");

print ::CLIENT<<EOF;
<H1><Center>Excluded Vulnerabilities - by host/severity</Center></H1>
<HR>
EOF

#Form an sorted list of hosts, with wildcard host at head of list
my %temphash = map { $_=>undef } keys %Exclusions::exclusions_by_host;
my $have_wild = exists $temphash{"*"};
delete $temphash{"*"};
my @hosts = sort keys %temphash;
if ( $have_wild) { unshift @hosts, "*"; }

my ( $host, $hostname, @sevs, $sev, $exclist, @excs, $exc, $sevname, $color );
my $encoded_exc;
my $phash;

if ( scalar(@hosts) < 1 )
{	print ::CLIENT "\n<h3>No exclusions currently defined<\h3>\n";
	generate_html_footer(\*::CLIENT);
	return;
}

foreach $host ( @hosts )
{	$hostname=$host;
	if ( $host eq "*" ) { $hostname="ALL HOSTS"; }

	print ::CLIENT "\n<h3>Exclusions applying to $hostname</h3>\n";

	#Now get a list of all severities, with wildcarded ones first
	$phash = $Exclusions::exclusions_by_host{$host};
	%temphash = map { $_=>undef } keys %$phash;
	$have_wild = exists $temphash{"*"};
	delete $temphash{"*"};
	@sevs = keys %temphash;
	if ( $have_wild) { unshift @sevs, "*"; }

	
	foreach $sev ( @sevs )
	{	$exclist = ${$Exclusions::exclusions_by_host{$host}}{$sev};
		@excs = split /\n/, $exclist;
		$sevname=$sev;
		if ( $sev eq "*" ) { $sevname="ALL SEVERITIES"; }

		foreach $exc ( @excs )
		{	my @exclusion=split_exclusion($exc);
			$encoded_exc=encode_url_arg($exc);
			my $severity=$exclusion[$::SEVERITY_FIELD];
			my $vuln="$sev ($exclusion[$::TEXT_FIELD])";
			$color = get_severity_dot_color($severity);
			print_vulnerability_by_host_line(\*::CLIENT,
				$vuln,$color,$exc, $myurl, 1);
			print ::CLIENT <<EOF;
&nbsp;&nbsp;&nbsp;
<a href="saint_exclusion_detail.pl,$encoded_exc">Details</a>
&nbsp;&nbsp;&nbsp;
<a href="saint_exclusion_edit_form.pl,$encoded_exc">Edit</a>
EOF
		}
		print ::CLIENT "</dl>\n";
	}
}

generate_html_footer(\*::CLIENT);


