#
# Report vulnerability classes
#
use strict;

my $myurl="saint_severity_types.pl";

sub sort_numeric {
	$::severity_type_count{$::b} <=> $::severity_type_count{$::a};
}

generate_html_header(\*::CLIENT,"Vulnerabilities - By Type");
print ::CLIENT <<EOF;
<CENTER><H1>Vulnerabilities - By Type</H1></CENTER>
<hr><UL><UL>
<h3>Number of hosts per vulnerability type.</h3>
EOF

&make_severity_exclusion_info();

my $found=undef;
my ($totcnt, $cnt, $igcnt, $str,$_type);

print ::CLIENT <<EOF;
<ul>
EOF
for (sort sort_numeric keys %::severity_type_host_info) {
	($_type = $_) =~ tr / \//?!/;

	$totcnt=$Exclusions::severity_type_total_count{$_};
	$igcnt=$Exclusions::severity_type_ignored_count{$_};
	$cnt=$::severity_type_count{$_};

	if ( $totcnt == 0 ) { next; }
	if ( $cnt == 0 && ! $Exclusions::display_ignored ) { next; }
	$found=1;

	$str="";
	if ( $cnt > 1 )
	{       $str="$cnt hosts";
	} elsif ( $cnt == 1 )
	{       $str="$cnt host";
	}

	if ( $igcnt > 1 && $Exclusions::display_ignored )
	{       if ( $str )
		{       $str.= " (plus $igcnt hosts ignored)";
		} else
		{       $str.= " ($igcnt hosts ignored)";
		}
	} elsif ( $igcnt == 1&& $Exclusions::display_ignored)
	{       if ( $str )
		{       $str.= " (plus $igcnt host ignored)"
;
		} else
		{       $str.= " ($igcnt host ignored)";
		}
	}

	print ::CLIENT <<EOF;
	<li> 
	<a href="saint_severity_hosts.pl,$_type,">
	$_ - $str</a>
EOF
}
print ::CLIENT "</ul>\n";

if ( $found )
{     print ::CLIENT <<EOF;
<strong>Note: hosts may appear in multiple categories. </strong>
EOF
} else {
    print ::CLIENT <<EOF
No vulnerability information found.
EOF
}

print_show_hide_html_message(\*::CLIENT,$myurl);
print ::CLIENT <<EOF
<hr> <a href=$::HTML_STARTPAGE> Back to the SAINT start page </a> |
<a href=analysis.pl> Back to SAINT Reporting and Analysis </a>
</UL></UL>
EOF
;

generate_html_footer(\*::CLIENT);
