#
# perl/saintwriter.pl
#
# rewrite saintwriter.cf after the user changes it.
#
# suck in the changes, then just cycle through each line of the .cf file.
# if there is a match, put the new value in there.
#

sub write_saintwriter_file {
local($new_values) = @_;
local(%new_values, $variable, $old_variable, $old_value);

#
# split the strings into something easier to handle
for ( split(/\n/, $new_values) ) {
	next if !$_;

	($variable, $value) = split(/=/, $_);

	# need to stick a dollar sign in front of var
	$variable = "\$" . "$variable";
	# put quotes around value
	# and convert plusses back to spaces
	$value = "\"$value\"";
	$value =~ s/\+/ /g;

	$new_values{$variable} = $value;
	}

    # check if it's the long form or the short form
    $long_form = ($new_values{'$longform'} eq "\"on\"")?1:0;

    # check if it's a custom report type
    if ($new_values{'$report'} eq "\"other\"") {

	# check if a saved report type was selected
	if ($new_values{'$saved'} =~ /\w/) {
	    $new_values{'$report'} = $new_values{'$saved'};
        }

	# it's a new report type
	else {
	    $new_values{'$report'} = $new_values{'$new_file'};
	    $new_values{'$report'} =~ s/\.cf\"/\"/;

	    # make sure the new filename isn't empty
	    if ($new_values{'$report'} !~ /\w/) {
		@date = localtime(time());
		$timestamp = sprintf "%02d%02d%02d,%02d%02d",
		    $date[5]%100, $date[4]+1, $date[3], $date[2], $date[1];
		$new_values{'$report'} = "\"$timestamp\"";
	    }

	    # protect the real saintwriter.cf
	    $new_values{'$report'} = "\"saintwriter_cf\""
	        if ($new_values{'$report'} eq "\"saintwriter\"");

	    # check whether it already exists; if not, create it
	    ($configfile = "config/saintwriter/$new_values{'$report'}.cf") =~ s/\"//g;
	    ($template = "config/saintwriter/$new_values{'$template'}.cf") =~ s/\"//g;
	    if (! -f "$configfile") {
	        die "Can't create config file\n"
		    unless open(CFN, "> $configfile");
	        die "Can't open template for new config file\n"
		    unless open(CF, "< $template");
	    	while(<CF>) {
		    s/$1/$new_values{'$template'}/ if /\$report\s*=\s*"([^"]+)"/;
		    print CFN;
	        }
	        close CF;
	        close CFN;
	    }
	}
    }
#
# re-create the basic config file
#
    $configfile = "config/saintwriter/saintwriter.cf";
    die "Can't read $configfile.new\n" unless open(CFN, ">$configfile.new");

    print CFN "# Basic SAINTwriter configuration\n";
    print CFN "\$report = $new_values{'$report'};\n";
    print CFN "\$report_title = $new_values{'$report_title'};\n";
    print CFN "\$format = $new_values{'$format'};\n";
    if ($new_values{'$riskwatch'} =~ /on/) {
	print CFN "\$riskwatch = \"on\";\n";
    } else {
	print CFN "\$riskwatch = \"off\";\n";
    }
    for $variable (keys %new_values) {
	if ($variable =~ /^\$dataset_/) {
	    ($data_set = $variable) =~ s/\$dataset_//;
	    print CFN "\$dataset{'$data_set'} = $new_values{$variable};\n";
	}
    }
    print CFN "1;\n";
    close(CFN);

    system("mv $configfile $configfile.old");
    system("mv $configfile.new $configfile");

#
# open the report-specific config file
#
$configfile = "config/saintwriter/$new_values{'$report'}.cf";
$configfile =~ s/\"//g;
die "Can't read $configfile\n" unless open(CF, "$configfile");
die "Can't write $configfile.new\n" unless open(CFN, ">$configfile.new");

while (<CF>) {
	if (/^# Begin vulnerabilities/ && $long_form) {
	    print CFN;
	    for $variable (keys %new_values) {
		if ($variable =~ /^\$red_/ ||
		    $variable =~ /^\$yellow_/ ||
		    $variable =~ /^\$brown_/ ||
		    $variable =~ /^\$green_/) {
			print CFN "$variable = $new_values{$variable};\n";
		}
	    }	
	    $_ = <CF>;
	    while (! /^# End vulnerabilities/) {
		$_ = <CF>;
	    }
	}
	if (/^# Begin data sets/ &&
	     ($long_form || $new_values{'$report'} eq "\"trend\"")) {
	    print CFN;
	    for $variable (keys %new_values) {
		if ($variable =~ /^\$dataset_/) {
		    ($data_set = $variable) =~ s/\$dataset_//;
		    print CFN "\$dataset{'$data_set'} = $new_values{$variable};\n";
		}
	    }
	    $_ = <CF>;
	    while (! /^# End data sets/) {
		$_ = <CF>;
	    }
	}

	if (!/^\$/) {
		print CFN $_;
		next;
		}
	
	chop;
	($old_variable, $old_value) = split(/\s*=\s*/, $_);

	# kill spaces and semicolons
	$old_variable =~ s/\s//g;
	$old_value =~ s/;//g;
	if ($long_form) {
	    $old_value = "\"off\"" if ($old_value eq "\"on\"" || $old_value eq "\"reverse\"");
	}

	# suck in the lines, compare them to each of the vars gotten from user
	for $variable (keys %new_values) {
		if ($variable eq $old_variable) {
			$old_value = $new_values{$variable};
			}
		}

	print CFN "$old_variable = $old_value;\n";
	}

close(CF);
close(CFN);

# move the evidence to where it belongs... old to .old, new to .cf:
system("mv $configfile $configfile.old");
system("mv $configfile.new $configfile");

}

1;
