#!/usr/bin/perl

# AllMods.pm, distributed as part of Snortsnarf v020124.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2001 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/software/snortsnarf/
# for details.

# AllMods contains a list of available files holding instance of various
# SnortSnarf APIs and provides functions to load each of these into memory
# using 'require'.

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program.

package AllMods;

# list all available input module files here
@all_input_files= qw (
    SnortFileInput.pm
);
@all_storage_files= qw (
    MemStorage.pm
    HTMLMemStorage.pm
    HTMLAnomMemStorage.pm
);
@all_output_files= qw (
    HTMLOutput.pm
);

@all_filter_files= qw (
    BasicFilters.pm
);
@all_sorter_files= qw (
    BasicSorters.pm
);
@all_alert_files= qw (
    MemAlert.pm
);
@all_packet_files= qw (
    MemPacket.pm
);


sub load_all_input_modules {
    foreach (@all_input_files) {
        eval { require $_; };
        warn "could not load input module file \"$_\"" if ($@);
    }
}

sub load_all_storage_modules {
    foreach (@all_storage_files) {
        eval { require $_; };
        warn "could not load storage module file \"$_\"" if ($@);
    }
}

sub load_all_output_modules {
    foreach (@all_output_files) {
        eval { require $_; };
        warn "could not load output module file \"$_\"" if ($@);
    }
}

sub load_all_modules {
    foreach (@all_input_files,@all_storage_files,@all_output_files,@all_filter_files,@all_sorter_files,@all_alert_files,@all_packet_files) {
        eval { require $_; };
        warn "could not load module file \"$_\"" if ($@);
    }
}
