#!/bin/sh

if ! PREFIX=$(expr $0 : "\(/.*\)/etc/rc\.d/$(basename $0)\$"); then
    echo "$0: Cannot determine the PREFIX" >&2
    exit 1
fi

case "$1" in
	start)
		[ -x ${PREFIX}/sbin/healthd ] && ${PREFIX}/sbin/healthd && echo -n ' healthd'
		;;
	stop)
		/usr/bin/killall healthd > /dev/null 2>&1 && echo -n ' healthd'
		;;
	reload)
		/usr/bin/killall -HUP healthd > /dev/null 2>&1 && echo -n ' healthd'
		;;
	*)
		echo ""
		echo "Usage: `basename $0` { start | stop | reload }"
		echo ""
		exit 1
		;;
esac
