# Useful functions for C programmers

# Locate all things which look like function definitions in C, collect them up, and
# dump them into a new window as prototypes.
proc GetCPrototypes {theWindow} \
{
	setmark $theWindow temp;									# remember what was selected, we will not disturb it
	TextToBuffer tempFindBuffer {^[A-Za-z][^(;,\n]+\([^)]*\)[ \t]*(\{.*[\{]*)*(//.*)*(/\*.*)*$};	# load up the expression
	setselectionends $theWindow 0 0;							# move to the top of the buffer to perform the search
	if {[catch {findall $theWindow tempFindBuffer -regex} message]==0} \
	{
		if {$message!=-1} \
		{
			set theName [newbuffer [NewWindowName]];			# make a buffer to hold the prototypes
			copy $theWindow $theName;							# get selected prototypes into a buffer
			setselectionends $theName 0 0;						# move to the top of the prototypes buffer
			# see if the last line is terminated with a new-line, if not, add one
			set end [lindex [textinfo $theName] 1];				# get position of end of buffer
			if {[lindex [positiontolineoffset $theName $end] 1]!=0} \
			{
				setselectionends $theName $end $end;			# move to the end of the prototypes buffer
				insert $theName "\n";							# terminate the last line
				setselectionends $theName 0 0;					# move to the top of the prototypes buffer
			}
			TextToBuffer tempFindBuffer {^[ \t]*static.*\n};	# get rid of any static functions
			TextToBuffer tempReplaceBuffer {};
			catch {replaceall $theName tempFindBuffer tempReplaceBuffer -regex} message;	# do this, ignore any errors
			setselectionends $theName 0 0;						# move to the top of the prototypes buffer
			TextToBuffer tempFindBuffer {\)[^\n]*$};			# make all parens at end of line have ;'s
			TextToBuffer tempReplaceBuffer {);};
			catch {replaceall $theName tempFindBuffer tempReplaceBuffer -regex} message;	# do this, ignore any errors

			set end [lindex [textinfo $theName] 1];				# get position of end of buffer
			# see if the last line is terminated with a new-line, if not, add one
			if {[lindex [positiontolineoffset $theName $end] 1]!=0} \
			{
				setselectionends $theName $end $end;			# move to the end of the prototypes buffer
				insert $theName "\n";							# terminate the last line
			}

			setselectionends $theName 0 0;						# move to the top of the prototypes buffer
			flushundos $theName;								# get rid of any undos we made here, just to be nice
			cleardirty $theName;								# make it non-modified
			OpenDefaultWindow $theName;							# give it to the user
			SetHighlightMode $theName "C/C++";					# make it look like C code
		} \
		else \
		{
			beep
		}
	} \
	else \
	{
		okdialog $message
	}
	gotomark $theWindow temp;									# put back the user's selection
	clearmark $theWindow temp;									# get rid of temp selection
}

# Locate all function like lines, bring them up in a list box, allowing the
# user to choose one, then move to the chosen one.
proc SelectCFunction {theWindow} \
{
	setmark $theWindow temp;									# remember what was selected, we will not disturb it
	TextToBuffer tempFindBuffer {^[A-Za-z][^(;,\n]+\([^)]*\)[ \t]*(\{.*[\{]*)*(//.*)*(/\*.*)*$};	# load up the expression
	setselectionends $theWindow 0 0;							# move to the top of the buffer to perform the search
	if {[catch {findall $theWindow tempFindBuffer -regex} message]==0} \
	{
		if {$message!=-1} \
		{
			set theName [newbuffer [NewWindowName]];			# make a buffer to hold the prototypes
			copy $theWindow $theName;							# get selected prototypes into a buffer
			setselectionends $theWindow 0 0;					# move to the top of the buffer
			setselectionends $theName 0 0;						# move to the top of the prototypes buffer
			# see if the last line is terminated with a new-line, if not, add one
			set end [lindex [textinfo $theName] 1];				# get position of end of buffer
			if {[lindex [positiontolineoffset $theName $end] 1]!=0} \
			{
				setselectionends $theName $end $end;			# move to the end of the prototypes buffer
				insert $theName "\n";							# terminate the last line
			}

			set end [lindex [textinfo $theName] 1];				# get position of end of buffer
			# see if the last line is terminated with a new-line, if not, add one
			if {[lindex [positiontolineoffset $theName $end] 1]!=0} \
			{
				setselectionends $theName $end $end;			# move to the end of the prototypes buffer
				insert $theName "\n";							# terminate the last line
			}

			setselectionends $theName 0 0;						# move to the top of the prototypes buffer
			flushundos $theName;								# get rid of any undos we made here, just to be nice
			cleardirty $theName;								# make it non-modified
			TextToBuffer tempFindBuffer {^[A-Za-z][^(;,\n]+\([^)]*\)};	# load up the expression
			if {[catch {findall $theName tempFindBuffer -regex} message]==0} \
			{
				if {$message!=-1} \
				{
					catch {listdialog "Choose a Function:" [selectedtextlist $theName]} theChoice
					if {[llength $theChoice]>=1} \
					{
						TextToBuffer tempFindBuffer [lindex $theChoice 0]
						setselectionends $theWindow 0 0;				# move to the top of the buffer to perform the search
						catch {find $theWindow tempFindBuffer} message
						HomeWindowToSelectionStart $theWindow -strict
					} \
					else \
					{
						gotomark $theWindow temp;				# put back the user's selection
					}
				} \
				else \
				{
					beep
					gotomark $theWindow temp;					# put back the user's selection
				}
			} \
			else \
			{
				okdialog $message
				gotomark $theWindow temp;						# put back the user's selection
			}
			closebuffer $theName;								# get rid of the buffer
		} \
		else \
		{
			beep
			gotomark $theWindow temp;							# put back the user's selection
		}
	} \
	else \
	{
		okdialog $message
		gotomark $theWindow temp;								# put back the user's selection
	}
	clearmark $theWindow temp;									# get rid of temp selection
}

# Paste all of the selections in the clipboard as case statements in 'C'
# into theWindow.
# This is handy when columnar selecting a bunch of enumerations, or
# defines to build a large switch statement from.
proc CasePaste {theWindow} \
{
	breakundo $theWindow
	foreach theItem [selectedtextlist [getclipboard]] \
	{
		insert $theWindow "case $theItem:\n\tbreak;\n"
	}
	breakundo $theWindow
}

addmenu {} LASTCHILD 1 "C" "" ""
	addmenu {C} LASTCHILD 1 "Get Prototypes"					{}				{GetCPrototypes [ActiveWindowOrBeep]}
	addmenu {C} LASTCHILD 1 "Locate Function..."				{}				{SelectCFunction [ActiveWindowOrBeep]}
	addmenu {C} LASTCHILD 0 "space1"							{\\S}			{}
	addmenu {C} LASTCHILD 1 "Case Paste"						{}				{CasePaste [ActiveWindowOrBeep]}
