/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CommandLine {
    private String foFile = null;
    private String pdfFile = null;
    private static boolean errorDump = false;

    public CommandLine(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d") || stringArray[n].equals("--full-error-dump")) {
                errorDump = true;
            } else if (stringArray[n].charAt(0) == '-') {
                this.printUsage(stringArray[n]);
            } else if (this.foFile == null) {
                this.foFile = stringArray[n];
            } else if (this.pdfFile == null) {
                this.pdfFile = stringArray[n];
            } else {
                this.printUsage(stringArray[n]);
            }
            ++n;
        }
        if (this.foFile == null || this.pdfFile == null) {
            this.printUsage(null);
        }
    }

    static XMLReader createParser() {
        block9: {
            String string = System.getProperty("org.xml.sax.parser");
            if (string == null) {
                string = "org.apache.xerces.parsers.SAXParser";
            }
            MessageHandler.logln("using SAX parser " + string);
            try {
                return (XMLReader)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageHandler.errorln("Could not find " + string);
                if (errorDump) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                MessageHandler.errorln("Could not instantiate " + string);
                if (errorDump) {
                    instantiationException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                MessageHandler.errorln("Could not access " + string);
                if (errorDump) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (ClassCastException classCastException) {
                MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
                if (!errorDump) break block9;
                classCastException.printStackTrace();
            }
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        String string = Version.getVersion();
        MessageHandler.errorln(string);
        CommandLine commandLine = new CommandLine(stringArray);
        commandLine.run();
    }

    public void printUsage(String string) {
        if (string != null) {
            MessageHandler.errorln("Unkown argument: '" + string + "'");
            MessageHandler.errorln("Usage: java [-d]org.apache.fop.apps.CommandLine formatting-object-file pdf-file");
            MessageHandler.errorln("Options:\n  -d or --full-error-dump    Show stack traces upon error");
            System.exit(1);
        }
    }

    public void run() {
        XMLReader xMLReader = CommandLine.createParser();
        if (xMLReader == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            if (errorDump) {
                sAXException.printStackTrace();
            }
            System.exit(1);
        }
        try {
            Driver driver = new Driver();
            driver.setErrorDump(errorDump);
            driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", Version.getVersion());
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
            driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            driver.buildFOTree(xMLReader, CommandLine.fileInputSource(this.foFile));
            driver.format();
            driver.setWriter(new PrintWriter(new FileWriter(this.pdfFile)));
            driver.render();
        }
        catch (Exception exception) {
            MessageHandler.errorln("FATAL ERROR: " + exception.getMessage());
            if (errorDump) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }
}

