/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.messaging.MessageHandler;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XalanCommandLine {
    static XMLReader createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        MessageHandler.logln("using SAX parser " + string);
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        XMLReader xMLReader;
        String string = Version.getVersion();
        MessageHandler.logln(string);
        if (stringArray.length != 3) {
            MessageHandler.errorln("usage: java org.apache.fop.apps.XalanCommandLine xml-file xslt-file pdf-file");
            System.exit(1);
        }
        if ((xMLReader = XalanCommandLine.createParser()) == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            System.exit(1);
        }
        try {
            Writer writer;
            boolean bl = false;
            MessageHandler.logln("transforming to xsl:fo markup");
            if (new File(stringArray[0]).length() > 500000L) {
                writer = new FileWriter(String.valueOf(stringArray[2]) + ".tmp");
                bl = true;
            } else {
                writer = new StringWriter();
            }
            XSLTProcessor xSLTProcessor = XSLTProcessorFactory.getProcessor();
            XMLParserLiaison xMLParserLiaison = xSLTProcessor.getXMLProcessorLiaison();
            URL uRL = xMLParserLiaison.getURLFromString(stringArray[0], null);
            System.err.println("XML File: " + stringArray[0]);
            System.err.println("URL: " + uRL);
            XSLTInputSource xSLTInputSource = new XSLTInputSource(uRL.toString());
            uRL = xMLParserLiaison.getURLFromString(stringArray[1], null);
            System.err.println("XSL File: " + stringArray[1]);
            System.err.println("URL: " + uRL);
            XSLTInputSource xSLTInputSource2 = new XSLTInputSource(uRL.toString());
            XSLTResultTarget xSLTResultTarget = new XSLTResultTarget(writer);
            xSLTProcessor.process(xSLTInputSource, xSLTInputSource2, xSLTResultTarget);
            Reader reader = bl ? new FileReader(String.valueOf(stringArray[2]) + ".tmp") : new StringReader(writer.toString());
            writer.flush();
            writer.close();
            Driver driver = new Driver();
            driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", string);
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
            driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(stringArray[2])));
            driver.setWriter(printWriter);
            driver.buildFOTree(xMLReader, new InputSource(reader));
            reader.close();
            driver.format();
            driver.render();
            if (bl) {
                new File(String.valueOf(stringArray[2]) + ".tmp").delete();
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            MessageHandler.errorln("FATAL ERROR: " + exception.getMessage());
            System.exit(1);
        }
    }
}

