/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDNode;
import org.apache.fop.layout.Area;
import org.apache.fop.pdf.PDFGoTo;

public class IDReferences {
    private Hashtable idReferences = new Hashtable();
    private Hashtable idValidation = new Hashtable();
    static final int ID_PADDING = 5000;

    public void addToIdValidationList(String string) {
        this.idValidation.put(string, "");
    }

    public void configureID(String string, Area area) {
        if (string != null && !string.equals("")) {
            this.setPosition(string, area.getPage().getBody().getXPosition() + area.getTableCellXOffset() - 5000, area.getPage().getBody().getYPosition() - area.getAbsoluteHeight() + 5000);
            this.setPageNumber(string, area.getPage().getNumber());
            area.getPage().addToIDList(string);
        }
    }

    public void createID(String string) throws FOPException {
        if (string != null && !string.equals("")) {
            if (this.doesIDExist(string)) {
                throw new FOPException("The id \"" + string + "\" already exists in this document");
            }
            this.createNewId(string);
            this.removeFromIdValidationList(string);
        }
    }

    public String createInternalLinkGoTo(String string, int n) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        iDNode.createInternalLinkGoTo(n);
        return iDNode.getInternalLinkGoToReference();
    }

    public void createNewId(String string) {
        IDNode iDNode = new IDNode(string);
        this.idReferences.put(string, iDNode);
    }

    public boolean doesGoToReferenceExist(String string) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        return iDNode.isThereInternalLinkGoTo();
    }

    public boolean doesIDExist(String string) {
        return this.idReferences.containsKey(string);
    }

    public String getInternalLinkGotToReference(String string) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        return iDNode.getInternalLinkGoToReference();
    }

    public String getInvalidIds() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.idValidation.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n\"").append(enumeration.nextElement().toString()).append("\" ");
        }
        return stringBuffer.toString();
    }

    public PDFGoTo getPDFGoTo(String string) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        return iDNode.getInternalLinkGoTo();
    }

    public String getPageNumber(String string) {
        if (this.doesIDExist(string)) {
            IDNode iDNode = (IDNode)this.idReferences.get(string);
            return iDNode.getPageNumber();
        }
        this.addToIdValidationList(string);
        return null;
    }

    public void initializeID(String string, Area area) throws FOPException {
        this.createID(string);
        this.configureID(string, area);
    }

    public boolean isEveryIdValid() {
        return this.idValidation.size() == 0;
    }

    public void removeFromIdValidationList(String string) {
        this.idValidation.remove(string);
    }

    public void removeID(String string) {
        this.idReferences.remove(string);
    }

    public void setInternalGoToPageReference(String string, String string2) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        iDNode.setInternalLinkGoToPageReference(string2);
    }

    public void setPageNumber(String string, int n) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        iDNode.setPageNumber(n);
    }

    public void setPosition(String string, int n, int n2) {
        IDNode iDNode = (IDNode)this.idReferences.get(string);
        iDNode.setPosition(n, n2);
    }
}

