/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.datatypes.Length;

public class LengthRange {
    private Length minimum;
    private Length optimum;
    private Length maximum;
    private static final int MINSET = 1;
    private static final int OPTSET = 2;
    private static final int MAXSET = 4;
    private int bfSet = 0;

    public LengthRange(Length length) {
        this.minimum = length;
        this.optimum = length;
        this.maximum = length;
    }

    public Length getMaximum() {
        return this.maximum;
    }

    public Length getMinimum() {
        return this.minimum;
    }

    public Length getOptimum() {
        return this.optimum;
    }

    public void setMaximum(Length length) {
        if ((this.bfSet & 2) == 0) {
            if ((this.bfSet & 1) != 0 && length.mvalue() < this.minimum.mvalue()) {
                length = this.minimum;
            }
        } else if (length.mvalue() < this.optimum.mvalue()) {
            length = this.optimum;
        }
        this.maximum = length;
        this.bfSet |= 4;
    }

    public void setMinimum(Length length) {
        if ((this.bfSet & 2) == 0) {
            if ((this.bfSet & 4) != 0 && length.mvalue() > this.maximum.mvalue()) {
                length = this.maximum;
            }
        } else if (length.mvalue() > this.optimum.mvalue()) {
            length = this.optimum;
        }
        this.minimum = length;
        this.bfSet |= 1;
    }

    public void setOptimum(Length length) {
        if (!((this.bfSet & 1) != 0 && length.mvalue() < this.minimum.mvalue() || (this.bfSet & 4) != 0 && length.mvalue() > this.maximum.mvalue())) {
            this.optimum = length;
            this.bfSet |= 2;
        }
    }
}

