/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.css;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.dom.css.CSSPrimitiveValueImpl;
import org.apache.fop.dom.css.CSSValueImpl;
import org.apache.fop.dom.css.CSSValueListImpl;
import org.apache.fop.dom.css.RGBColorImpl;
import org.apache.fop.dom.svg.SVGLengthImpl;
import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration {
    Hashtable table = new Hashtable();

    public String getCssText() {
        return null;
    }

    public int getLength() {
        return this.table.size();
    }

    public CSSRule getParentRule() {
        return null;
    }

    public CSSValue getPropertyCSSValue(String string) {
        return (CSSValue)this.table.get(string);
    }

    public String getPropertyPriority(String string) {
        return null;
    }

    public String getPropertyValue(String string) {
        return this.getPropertyCSSValue(string).getCssText();
    }

    public String item(int n) {
        return null;
    }

    protected void parseStyleText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(":");
            if (n != -1) {
                CSSValueImpl cSSValueImpl;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1, string2.length()).trim();
                if (string3.equals("stroke-width")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke")) {
                    cSSValueImpl = new RGBColorValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("color")) {
                    cSSValueImpl = new RGBColorValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke-linecap")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke-linejoin")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke-miterlimit")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke-dasharray")) {
                    if (!string4.equals("none")) {
                        cSSValueImpl = new CSSValueListImpl();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, " ,");
                        while (stringTokenizer2.hasMoreTokens()) {
                            LengthValue lengthValue = new LengthValue();
                            lengthValue.setCssText(stringTokenizer2.nextToken());
                            ((CSSValueListImpl)cSSValueImpl).addValue(lengthValue);
                        }
                        this.table.put(string3, cSSValueImpl);
                        continue;
                    }
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke-dashoffset")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stroke-opacity")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("fill")) {
                    cSSValueImpl = new RGBColorValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("fill-rule")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-size")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-family")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-weight")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-style")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-variant")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-stretch")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("font-size-adjust")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("letter-spacing")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("word-spacing")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("text-decoration")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("mask")) {
                    cSSValueImpl = new URIValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("fill-opacity")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("opacity")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("filter")) continue;
                if (string3.equals("stop-color")) {
                    cSSValueImpl = new RGBColorValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("stop-opacity")) {
                    cSSValueImpl = new LengthValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("overflow")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("clip-rule")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("clip-path")) {
                    cSSValueImpl = new URIValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("clip")) {
                    cSSValueImpl = new URIValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("marker-start")) {
                    cSSValueImpl = new URIValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("marker-mid")) {
                    cSSValueImpl = new URIValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("marker-end")) {
                    cSSValueImpl = new URIValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("text-antialiasing") || string3.equals("stroke-antialiasing") || string3.equals("writing-mode") || string3.equals("glyph-orientation-vertical") || string3.equals("glyph-orientation-horizontal") || string3.equals("direction") || string3.equals("unicode-bidi")) continue;
                if (string3.equals("text-anchor")) {
                    cSSValueImpl = new StringValue();
                    cSSValueImpl.setCssText(string4);
                    this.table.put(string3, cSSValueImpl);
                    continue;
                }
                if (string3.equals("dominant-baseline") || string3.equals("baseline-identifier") || string3.equals("baseline-shift") || string3.equals("font-size-adjust")) continue;
                MessageHandler.logln("WARNING: Unknown style element : " + string3);
                continue;
            }
            if ("".equals(string2.trim())) continue;
            MessageHandler.errorln("ERROR: Invalid style element " + string2);
        }
    }

    public String removeProperty(String string) {
        return null;
    }

    public void setCssText(String string) {
        try {
            this.parseStyleText(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setProperty(String string, String string2, String string3) {
    }

    class RGBColorValue
    extends CSSPrimitiveValueImpl {
        RGBColor col = null;

        RGBColorValue() {
        }

        public RGBColor getRGBColorValue() {
            return this.col;
        }

        public void setCssText(String string) {
            super.setCssText(string);
            if (string.startsWith("url(")) {
                this.primType = (short)20;
            } else if (string.equals("currentColor")) {
                this.primType = (short)19;
            } else if (!string.equals("none")) {
                ColorType colorType = new ColorType(string);
                float f = colorType.red();
                float f2 = colorType.green();
                float f3 = colorType.blue();
                this.col = new RGBColorImpl(f, f2, f3);
                this.primType = (short)25;
            } else {
                this.primType = (short)19;
            }
        }
    }

    class LengthValue
    extends CSSPrimitiveValueImpl {
        LengthValue() {
        }

        public void setCssText(String string) {
            super.setCssText(string);
            SVGLengthImpl sVGLengthImpl = new SVGLengthImpl(string);
            this.floatVal = sVGLengthImpl.getValue();
            switch (sVGLengthImpl.getUnitType()) {
                case 8: {
                    this.primType = (short)8;
                    break;
                }
                case 6: {
                    this.primType = (short)6;
                    break;
                }
                case 7: {
                    this.primType = (short)7;
                    break;
                }
                case 9: {
                    this.primType = (short)9;
                    break;
                }
                case 10: {
                    this.primType = (short)10;
                    break;
                }
                case 3: {
                    this.primType = (short)3;
                    break;
                }
                case 5: {
                    this.primType = (short)5;
                    break;
                }
                case 2: {
                    this.primType = (short)2;
                    break;
                }
                case 1: {
                    this.primType = 1;
                    break;
                }
            }
        }
    }

    class StringValue
    extends CSSPrimitiveValueImpl {
        StringValue() {
        }

        public void setCssText(String string) {
            super.setCssText(string);
            this.primType = (short)19;
        }
    }

    class URIValue
    extends CSSPrimitiveValueImpl {
        URIValue() {
        }

        public void setCssText(String string) {
            super.setCssText(string);
            this.primType = (short)20;
        }
    }
}

