/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.svg;

import java.util.StringTokenizer;
import org.apache.fop.dom.svg.SVGListImpl;
import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.svg.SVGLengthList;

public class SVGLengthListImpl
extends SVGListImpl
implements SVGLengthList {
    protected float fontsize = 12.0f;

    public SVGLengthListImpl() {
    }

    public SVGLengthListImpl(String string) {
        this.convert(string);
    }

    public SVGLengthListImpl(String string, int n) {
        this.fontsize = n;
        this.convert(string);
    }

    protected void convert(String string) {
        int n = string.length();
        if (n != 0) {
            int n2 = string.trim().indexOf(" ");
            if (n2 != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
                while (stringTokenizer.hasMoreTokens()) {
                    float f;
                    String string2 = stringTokenizer.nextToken();
                    float f2 = f = this.getFloatValue(string2, string2.length());
                    this.appendItem(new Float(f2));
                }
            } else {
                float f = this.getFloatValue(string, n);
                this.appendItem(new Float(f));
            }
        }
    }

    protected float getFloatValue(String string, int n) {
        float f;
        boolean bl = true;
        try {
            if (string.endsWith("in")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 72.0f;
            } else if (string.endsWith("cm")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 28.35f;
            } else if (string.endsWith("mm")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 2.84f;
            } else if (string.endsWith("pt")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
            } else if (string.endsWith("pc")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 12.0f;
            } else if (string.endsWith("em")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= this.fontsize;
            } else if (string.endsWith("px")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= (float)bl;
            } else {
                f = string.endsWith("%") ? Float.valueOf(string.substring(0, n - 1)).floatValue() / 100.0f : Float.valueOf(string).floatValue();
            }
        }
        catch (Exception exception) {
            f = 0.0f;
            MessageHandler.errorln("ERROR: unknown length units in " + string);
        }
        return f;
    }

    public void setValueAsString(String string) {
        this.convert(string);
    }
}

