/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.Numeric;

public class NumberProperty
extends Property {
    private final Number number;

    public NumberProperty(double d) {
        this.number = new Double(d);
    }

    public NumberProperty(int n) {
        this.number = new Integer(n);
    }

    public NumberProperty(Number number) {
        this.number = number;
    }

    public ColorType getColorType() {
        return new ColorType(0.0f, 0.0f, 0.0f);
    }

    public Number getNumber() {
        return this.number;
    }

    public Numeric getNumeric() {
        return new Numeric(this.number);
    }

    public Object getObject() {
        return this.number;
    }

    public static class Maker
    extends Property.Maker {
        public Maker(String string) {
            super(string);
        }

        protected Property convertProperty(Property property, PropertyList propertyList, FObj fObj) {
            if (property instanceof NumberProperty) {
                return property;
            }
            Number number = property.getNumber();
            if (number != null) {
                return new NumberProperty(number);
            }
            return this.convertPropertyDatatype(property, propertyList, fObj);
        }
    }
}

