/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.MixedLength;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.datatypes.TableColLength;
import org.apache.fop.fo.expr.PropertyException;

public class Numeric {
    public static final int ABS_LENGTH = 1;
    public static final int PC_LENGTH = 2;
    public static final int TCOL_LENGTH = 4;
    private int valType;
    private double absValue;
    private double pcValue;
    private PercentBase pcBase = null;
    private double tcolValue;
    private int dim;

    protected Numeric(int n, double d, double d2, double d3, int n2, PercentBase percentBase) {
        this.valType = n;
        this.absValue = d;
        this.pcValue = d2;
        this.tcolValue = d3;
        this.dim = n2;
        this.pcBase = percentBase;
    }

    public Numeric(Number number) {
        this(1, number.doubleValue(), 0.0, 0.0, 0, null);
    }

    public Numeric(Length length) {
        this(1, length.mvalue(), 0.0, 0.0, 1, null);
    }

    public Numeric(PercentLength percentLength) {
        this(2, 0.0, percentLength.value(), 0.0, 1, percentLength.getBaseLength());
    }

    public Numeric(TableColLength tableColLength) {
        this(4, 0.0, 0.0, tableColLength.getTableUnits(), 1, null);
    }

    public Numeric abs() {
        return new Numeric(this.valType, Math.abs(this.absValue), Math.abs(this.pcValue), Math.abs(this.tcolValue), this.dim, this.pcBase);
    }

    public Numeric add(Numeric numeric) throws PropertyException {
        if (this.dim == numeric.dim) {
            PercentBase percentBase = (this.valType & 2) != 0 ? this.pcBase : numeric.pcBase;
            return new Numeric(this.valType | numeric.valType, this.absValue + numeric.absValue, this.pcValue + numeric.pcValue, this.tcolValue + numeric.tcolValue, this.dim, percentBase);
        }
        throw new PropertyException("Can't add Numerics of different dimensions");
    }

    public Double asDouble() {
        if (this.dim == 0 && this.valType == 1) {
            return new Double(this.absValue);
        }
        return null;
    }

    public Length asLength() {
        if (this.dim == 1) {
            if (this.valType == 1) {
                return new Length((int)this.absValue);
            }
            PercentLength percentLength = null;
            if ((this.valType & 2) != 0) {
                percentLength = new PercentLength(this.pcValue, this.pcBase);
                if (this.valType == 2) {
                    return percentLength;
                }
            }
            if ((this.valType & 4) != 0) {
                return new TableColLength((int)this.absValue, percentLength, this.tcolValue);
            }
            return new MixedLength((int)this.absValue, percentLength);
        }
        return null;
    }

    public Number asNumber() {
        return this.asDouble();
    }

    public Numeric divide(Numeric numeric) throws PropertyException {
        if (this.dim == 0) {
            return new Numeric(numeric.valType, this.absValue / numeric.absValue, this.absValue / numeric.pcValue, this.absValue / numeric.tcolValue, -numeric.dim, numeric.pcBase);
        }
        if (numeric.dim == 0) {
            double d = numeric.absValue;
            return new Numeric(this.valType, this.absValue / d, this.pcValue / d, this.tcolValue / d, this.dim, this.pcBase);
        }
        if (this.valType == numeric.valType && !this.isMixedType()) {
            PercentBase percentBase = (this.valType & 2) != 0 ? this.pcBase : numeric.pcBase;
            return new Numeric(this.valType, this.valType == 1 ? this.absValue / numeric.absValue : 0.0, this.valType == 2 ? this.pcValue / numeric.pcValue : 0.0, this.valType == 4 ? this.tcolValue / numeric.tcolValue : 0.0, this.dim - numeric.dim, percentBase);
        }
        throw new PropertyException("Can't divide mixed Numerics.");
    }

    private boolean isMixedType() {
        int n = 0;
        int n2 = this.valType;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                ++n;
            }
            n2 >>= 1;
        }
        return n > 1;
    }

    public Numeric max(Numeric numeric) throws PropertyException {
        double d = 0.0;
        if (this.dim == numeric.dim && this.valType == numeric.valType && !this.isMixedType()) {
            if (this.valType == 1) {
                d = this.absValue - numeric.absValue;
            } else if (this.valType == 2) {
                d = this.pcValue - numeric.pcValue;
            } else if (this.valType == 4) {
                d = this.tcolValue - numeric.tcolValue;
            }
            if (d > 0.0) {
                return this;
            }
            return numeric;
        }
        throw new PropertyException("Arguments to max() must have same dimension and value type.");
    }

    public Numeric min(Numeric numeric) throws PropertyException {
        double d = 0.0;
        if (this.dim == numeric.dim && this.valType == numeric.valType && !this.isMixedType()) {
            if (this.valType == 1) {
                d = this.absValue - numeric.absValue;
            } else if (this.valType == 2) {
                d = this.pcValue - numeric.pcValue;
            } else if (this.valType == 4) {
                d = this.tcolValue - numeric.tcolValue;
            }
            if (d > 0.0) {
                return numeric;
            }
            return this;
        }
        throw new PropertyException("Arguments to min() must have same dimension and value type.");
    }

    public Numeric multiply(Numeric numeric) throws PropertyException {
        if (this.dim == 0) {
            return new Numeric(numeric.valType, this.absValue * numeric.absValue, this.absValue * numeric.pcValue, this.absValue * numeric.tcolValue, numeric.dim, numeric.pcBase);
        }
        if (numeric.dim == 0) {
            double d = numeric.absValue;
            return new Numeric(this.valType, d * this.absValue, d * this.pcValue, d * this.tcolValue, this.dim, this.pcBase);
        }
        if (this.valType == numeric.valType && !this.isMixedType()) {
            PercentBase percentBase = (this.valType & 2) != 0 ? this.pcBase : numeric.pcBase;
            return new Numeric(this.valType, this.absValue * numeric.absValue, this.pcValue * numeric.pcValue, this.tcolValue * numeric.tcolValue, this.dim + numeric.dim, percentBase);
        }
        throw new PropertyException("Can't multiply mixed Numerics");
    }

    public Numeric subtract(Numeric numeric) throws PropertyException {
        if (this.dim == numeric.dim) {
            PercentBase percentBase = (this.valType & 2) != 0 ? this.pcBase : numeric.pcBase;
            return new Numeric(this.valType | numeric.valType, this.absValue - numeric.absValue, this.pcValue - numeric.pcValue, this.tcolValue - numeric.tcolValue, this.dim, percentBase);
        }
        throw new PropertyException("Can't add Numerics of different dimensions");
    }
}

