/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.fo.expr.PropertyException;

class PropertyTokenizer {
    static final int TOK_EOF = 0;
    static final int TOK_NCNAME = 1;
    static final int TOK_MULTIPLY = 2;
    static final int TOK_LPAR = 3;
    static final int TOK_RPAR = 4;
    static final int TOK_LITERAL = 5;
    static final int TOK_NUMBER = 6;
    static final int TOK_FUNCTION_LPAR = 7;
    static final int TOK_PLUS = 8;
    static final int TOK_MINUS = 9;
    static final int TOK_MOD = 10;
    static final int TOK_DIV = 11;
    static final int TOK_NUMERIC = 12;
    static final int TOK_COMMA = 13;
    static final int TOK_PERCENT = 14;
    static final int TOK_COLORSPEC = 15;
    static final int TOK_FLOAT = 16;
    static final int TOK_INTEGER = 17;
    int currentToken = 0;
    String currentTokenValue = null;
    protected int currentUnitLength = 0;
    private int currentTokenStartIndex = 0;
    private final String expr;
    private int exprIndex = 0;
    private int exprLength;
    private boolean recognizeOperator = false;
    private static final String nameStartChars = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String nameChars = ".-0123456789";
    private static final String digits = "0123456789";
    private static final String hexchars = "0123456789abcdefABCDEF";

    PropertyTokenizer(String string) {
        this.expr = string;
        this.exprLength = string.length();
    }

    private boolean followingParen() {
        int n = this.exprIndex;
        while (n < this.exprLength) {
            switch (this.expr.charAt(n)) {
                case '(': {
                    this.exprIndex = n + 1;
                    return true;
                }
                default: {
                    return false;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            ++n;
        }
        return false;
    }

    private static final boolean isDigit(char c) {
        return digits.indexOf(c) >= 0;
    }

    private static final boolean isHexDigit(char c) {
        return hexchars.indexOf(c) >= 0;
    }

    private static final boolean isNameChar(char c) {
        return nameStartChars.indexOf(c) >= 0 || nameChars.indexOf(c) >= 0 || c >= '\u0080';
    }

    private static final boolean isNameStartChar(char c) {
        return nameStartChars.indexOf(c) >= 0 || c >= '\u0080';
    }

    private static final boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    void next() throws PropertyException {
        this.currentTokenValue = null;
        this.currentTokenStartIndex = this.exprIndex;
        boolean bl = this.recognizeOperator;
        this.recognizeOperator = true;
        block13: while (true) {
            if (this.exprIndex >= this.exprLength) {
                this.currentToken = 0;
                return;
            }
            char c = this.expr.charAt(this.exprIndex++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.currentTokenStartIndex = this.exprIndex;
                    continue block13;
                }
                case ',': {
                    this.recognizeOperator = false;
                    this.currentToken = 13;
                    return;
                }
                case '+': {
                    this.recognizeOperator = false;
                    this.currentToken = 8;
                    return;
                }
                case '-': {
                    this.recognizeOperator = false;
                    this.currentToken = 9;
                    return;
                }
                case '(': {
                    this.currentToken = 3;
                    this.recognizeOperator = false;
                    return;
                }
                case ')': {
                    this.currentToken = 4;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.exprIndex = this.expr.indexOf(c, this.exprIndex);
                    if (this.exprIndex < 0) {
                        this.exprIndex = this.currentTokenStartIndex + 1;
                        throw new PropertyException("missing quote");
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex + 1, this.exprIndex++);
                    this.currentToken = 5;
                    return;
                }
                case '*': {
                    if (!bl) {
                        throw new PropertyException("illegal operator *");
                    }
                    this.recognizeOperator = false;
                    this.currentToken = 2;
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean bl2;
                    this.scanDigits();
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '.') {
                        ++this.exprIndex;
                        bl2 = true;
                        if (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                            ++this.exprIndex;
                            this.scanDigits();
                        }
                    } else {
                        bl2 = false;
                    }
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '%') {
                        ++this.exprIndex;
                        this.currentToken = 14;
                    } else {
                        this.currentUnitLength = this.exprIndex;
                        this.scanName();
                        this.currentUnitLength = this.exprIndex - this.currentUnitLength;
                        this.currentToken = this.currentUnitLength > 0 ? 12 : (bl2 ? 16 : 17);
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                    return;
                }
                case '.': {
                    if (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                        ++this.exprIndex;
                        this.scanDigits();
                        if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '%') {
                            ++this.exprIndex;
                            this.currentToken = 14;
                        } else {
                            this.currentUnitLength = this.exprIndex;
                            this.scanName();
                            this.currentUnitLength = this.exprIndex - this.currentUnitLength;
                            this.currentToken = this.currentUnitLength > 0 ? 12 : 16;
                        }
                        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                        return;
                    }
                    throw new PropertyException("illegal character '.'");
                }
                case '#': {
                    if (this.exprIndex < this.exprLength && PropertyTokenizer.isHexDigit(this.expr.charAt(this.exprIndex))) {
                        ++this.exprIndex;
                        this.scanHexDigits();
                        this.currentToken = 15;
                        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                        return;
                    }
                    throw new PropertyException("illegal character '#'");
                }
            }
            break;
        }
        --this.exprIndex;
        this.scanName();
        if (this.exprIndex == this.currentTokenStartIndex) {
            throw new PropertyException("illegal character");
        }
        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
        if (bl) {
            if (this.currentTokenValue.equals("mod")) {
                this.currentToken = 10;
            } else if (this.currentTokenValue.equals("div")) {
                this.currentToken = 11;
            } else {
                throw new PropertyException("unrecognized operator name");
            }
            this.recognizeOperator = false;
            return;
        }
        if (this.followingParen()) {
            this.currentToken = 7;
            this.recognizeOperator = false;
        } else {
            this.currentToken = 1;
        }
    }

    private void scanDigits() {
        while (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private void scanHexDigits() {
        while (this.exprIndex < this.exprLength && PropertyTokenizer.isHexDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private void scanName() {
        if (this.exprIndex < this.exprLength && PropertyTokenizer.isNameStartChar(this.expr.charAt(this.exprIndex))) {
            while (++this.exprIndex < this.exprLength && PropertyTokenizer.isNameChar(this.expr.charAt(this.exprIndex))) {
            }
        }
    }
}

