/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.Area;
import org.apache.fop.messaging.MessageHandler;

public class Flow
extends FObj {
    private PageSequence pageSequence;
    private Area area;
    private String _flowName;
    private Status _status = new Status(2);

    protected Flow(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = this.getElementName();
        if (!fObj.getName().equals("fo:page-sequence")) {
            throw new FOPException("flow must be child of page-sequence, not " + fObj.getName());
        }
        this.pageSequence = (PageSequence)fObj;
        this.setFlowName(this.getProperty("flow-name").getString());
        this.pageSequence.addFlow(this);
    }

    protected int getContentWidth() {
        if (this.area != null) {
            return this.area.getContentWidth();
        }
        return 0;
    }

    protected String getElementName() {
        return "fo:flow";
    }

    public String getFlowName() {
        return this._flowName;
    }

    public Status getStatus() {
        return this._status;
    }

    public Status layout(Area area) throws FOPException {
        return this.layout(area, null);
    }

    public Status layout(Area area, Region region) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
        }
        this.area = area;
        boolean bl = false;
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            FObj fObj = (FObj)this.children.elementAt(n2);
            this._status = fObj.layout(area);
            if (this._status.isIncomplete()) {
                if (bl && this._status.laidOutNone()) {
                    this.marker = n2 - 1;
                    FObj fObj2 = (FObj)this.children.elementAt(this.marker);
                    fObj2.removeAreas();
                    fObj2.resetMarker();
                    fObj2.removeID(area.getIDReferences());
                    this._status = new Status(3);
                    return this._status;
                }
                this.marker = n2;
                return this._status;
            }
            bl = this._status.getCode() == 7;
            ++n2;
        }
        this._status = new Status(1);
        return this._status;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected void setFlowName(String string) throws FOPException {
        if (string == null || string.equals("")) {
            MessageHandler.errorln("WARNING: A 'flow-name' is required for " + this.getElementName() + ". This constraint will be enforced in future versions of FOP");
            this._flowName = "xsl-region-body";
        } else {
            this._flowName = string;
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Flow(fObj, propertyList);
        }
    }
}

