/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;

public class Leader
extends FObjMixed {
    public Leader(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:leader";
    }

    public Status layout(Area area) throws FOPException {
        int n;
        if (!(area instanceof BlockArea)) {
            MessageHandler.errorln("WARNING: in this version of Fop fo:leader must be a direct child of fo:block ");
            return new Status(1);
        }
        BlockArea blockArea = (BlockArea)area;
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n2 = this.properties.get("font-size").getLength().mvalue();
        FontState fontState = new FontState(area.getFontInfo(), string, string2, string3, n2);
        ColorType colorType = this.properties.get("color").getColorType();
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        int n3 = this.properties.get("leader-pattern").getEnum();
        int n4 = this.properties.get("leader-length.optimum").getLength().mvalue();
        int n5 = this.properties.get("leader-length.minimum").getLength().mvalue();
        if (n5 == 12000) {
            n5 = 0;
        }
        if ((n = this.properties.get("leader-length.maximum").getLength().mvalue()) == 12000) {
            n = 24000;
        }
        int n6 = this.properties.get("rule-thickness").getLength().mvalue();
        int n7 = this.properties.get("rule-style").getEnum();
        int n8 = this.properties.get("leader-pattern-width").getLength().mvalue();
        int n9 = this.properties.get("leader-alignment").getEnum();
        String string4 = this.properties.get("id").getString();
        blockArea.getIDReferences().initializeID(string4, blockArea);
        int n10 = blockArea.addLeader(fontState, f, f2, f3, n3, n5, n4, n, n6, n7, n8, n9);
        if (n10 == 1) {
            return new Status(1);
        }
        return new Status(3);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Leader(fObj, propertyList);
        }
    }
}

