/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;

public class ListBlock
extends FObj {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int provisionalDistanceBetweenStarts;
    int provisionalLabelSeparation;
    int spaceBetweenListRows = 0;
    ColorType backgroundColor;

    public ListBlock(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:list-block";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (this.marker == -1000) {
            object2 = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object2, string, string2, n);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.provisionalDistanceBetweenStarts = this.properties.get("provisional-distance-between-starts").getLength().mvalue();
            this.provisionalLabelSeparation = this.properties.get("provisional-label-separation").getLength().mvalue();
            this.spaceBetweenListRows = 0;
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.marker = 0;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.spaceBefore != 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
                this.bodyIndent = this.startIndent;
            }
            if (this.isInTableCell) {
                this.startIndent += this.forcedStartOffset;
                this.endIndent += area.getAllocationWidth() - this.forcedWidth - this.forcedStartOffset;
            }
            object = this.properties.get("id").getString();
            area.getIDReferences().initializeID((String)object, area);
        }
        object2 = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, this.align, this.alignLast, this.lineHeight);
        ((Area)object2).setPage(area.getPage());
        ((Area)object2).setBackgroundColor(this.backgroundColor);
        ((BlockArea)object2).start();
        ((Area)object2).setAbsoluteHeight(area.getAbsoluteHeight());
        ((Area)object2).setIDReferences(area.getIDReferences());
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            if (!(this.children.elementAt(n2) instanceof ListItem)) {
                MessageHandler.errorln("WARNING: This version of FOP requires list-items inside list-blocks");
                return new Status(1);
            }
            ListItem listItem = (ListItem)this.children.elementAt(n2);
            listItem.setDistanceBetweenStarts(this.provisionalDistanceBetweenStarts);
            listItem.setLabelSeparation(this.provisionalLabelSeparation);
            listItem.setBodyIndent(this.bodyIndent);
            object = listItem.layout((Area)object2);
            if (((Status)object).isIncomplete()) {
                this.marker = n2;
                ((BlockArea)object2).end();
                area.addChild((Box)object2);
                area.increaseHeight(((Area)object2).getHeight());
                area.setAbsoluteHeight(((Area)object2).getAbsoluteHeight());
                return object;
            }
            ++n2;
        }
        ((BlockArea)object2).end();
        area.addChild((Box)object2);
        area.increaseHeight(((Area)object2).getHeight());
        area.setAbsoluteHeight(((Area)object2).getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setBodyIndent(int n) {
        if (!this.isInListBody) {
            super.setBodyIndent(n);
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ListBlock(fObj, propertyList);
        }
    }
}

