/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;

public class PageNumberCitation
extends FObj {
    FontState fs;
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    Area area;
    String pageNumber;
    String refId;
    String id;

    public PageNumberCitation(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:page-number-citation";
    }

    public Status layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            MessageHandler.errorln("WARNING: page-number-citation outside block area");
            return new Status(1);
        }
        IDReferences iDReferences = area.getIDReferences();
        this.area = area;
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n);
            ColorType colorType = this.properties.get("color").getColorType();
            this.red = colorType.red();
            this.green = colorType.green();
            this.blue = colorType.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.refId = this.properties.get("ref-id").getString();
            if (this.refId.equals("")) {
                throw new FOPException("page-number-citation must contain \"ref-id\"");
            }
            this.id = this.properties.get("id").getString();
            iDReferences.createID(this.id);
            this.marker = 0;
        }
        if (this.marker == 0) {
            iDReferences.configureID(this.id, area);
        }
        this.pageNumber = iDReferences.getPageNumber(this.refId);
        this.marker = this.pageNumber != null ? ((BlockArea)area).addText(this.fs, this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, this.pageNumber.toCharArray(), 0, this.pageNumber.length(), false) : ((BlockArea)area).addPageNumberCitation(this.fs, this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, this.refId);
        if (this.marker == -1) {
            return new Status(1);
        }
        return new Status(2);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageNumberCitation(fObj, propertyList);
        }
    }
}

