/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.Area;

public class StaticContent
extends Flow {
    protected StaticContent(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
    }

    protected String getElementName() {
        return "fo:static-content";
    }

    public Status layout(Area area) throws FOPException {
        return this.layout(area, null);
    }

    public Status layout(Area area, Region region) throws FOPException {
        int n = this.children.size();
        String string = "none";
        if (region != null) {
            string = region.getRegionClass();
        } else if (this.getFlowName().equals("xsl-region-before")) {
            string = "before";
        } else if (this.getFlowName().equals("xsl-region-after")) {
            string = "after";
        }
        if (string.equals("before")) {
            area.setAbsoluteHeight(-area.getMaxHeight());
        } else if (string.equals("after")) {
            area.setAbsoluteHeight(area.getPage().getBody().getMaxHeight());
        }
        int n2 = 0;
        while (n2 < n) {
            FObj fObj = (FObj)this.children.elementAt(n2);
            Status status = fObj.layout(area);
            if (status.isIncomplete()) {
                this.marker = n2;
                if (n2 != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                return status;
            }
            ++n2;
        }
        this.resetMarker();
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected void setFlowName(String string) throws FOPException {
        if (string == null || string.equals("")) {
            throw new FOPException("A 'flow-name' is required for " + this.getElementName() + ".");
        }
        super.setFlowName(string);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new StaticContent(fObj, propertyList);
        }
    }
}

