/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;

public class Table
extends FObj {
    FontState fs;
    int breakBefore;
    int breakAfter;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    int width;
    int height;
    ColorType borderColor;
    int borderWidth;
    int borderStyle;
    String id;
    Vector columns = new Vector();
    int currentColumnNumber = 0;
    AreaContainer areaContainer;

    public Table(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table";
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    protected int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        int n;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n);
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.borderColor = this.properties.get("border-color").getColorType();
            this.borderWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderStyle = this.properties.get("border-style").getEnum();
            this.id = this.properties.get("id").getString();
            if (area instanceof BlockArea) {
                area.end();
            }
            area.getIDReferences().createID(this.id);
            this.marker = 0;
            if (this.breakBefore == 3) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        this.areaContainer = new AreaContainer(this.fs, 0, 0, area.getAllocationWidth(), area.spaceLeft(), 1);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderStyle, this.borderStyle, this.borderStyle, this.borderStyle);
        this.areaContainer.setBorderWidth(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
        this.areaContainer.setBorderColor(this.borderColor, this.borderColor, this.borderColor, this.borderColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        this.currentColumnNumber = 0;
        int n2 = 0;
        int n3 = this.children.size();
        int n4 = this.marker;
        while (n4 < n3) {
            FONode fONode = (FONode)this.children.elementAt(n4);
            if (fONode instanceof TableColumn) {
                object = (TableColumn)fONode;
                int n5 = ((TableColumn)object).getColumnNumber();
                if (n5 == 0) {
                    n5 = this.currentColumnNumber + 1;
                }
                this.currentColumnNumber = n5;
                if (n5 > this.columns.size()) {
                    this.columns.setSize(n5);
                }
                this.columns.setElementAt(object, n5 - 1);
                ((TableColumn)object).setColumnOffset(n2);
                fONode.layout(this.areaContainer);
                n2 += ((TableColumn)object).getColumnWidth();
            } else if (fONode instanceof TableBody) {
                if (this.columns.size() == 0) {
                    MessageHandler.errorln("WARNING: current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                ((TableBody)fONode).setColumns(this.columns);
                object = fONode.layout(this.areaContainer);
                if (((Status)object).isIncomplete()) {
                    this.marker = n4;
                    if (n4 != 0 && ((Status)object).getCode() == 2) {
                        object = new Status(3);
                    }
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                    area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                    return object;
                }
            }
            ++n4;
        }
        if (this.height != 0) {
            this.areaContainer.setHeight(this.height);
        }
        n = 0;
        while (n < n3) {
            object = (FONode)this.children.elementAt(n);
            if (object instanceof TableColumn) {
                ((TableColumn)object).setHeight(this.areaContainer.getHeight());
            }
            ++n;
        }
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Table(fObj, propertyList);
        }
    }
}

