/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class TableBody
extends FObj {
    FontState fs;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    String id;
    Vector columns;
    AreaContainer areaContainer;

    public TableBody(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-body";
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.id = this.properties.get("id").getString();
            area.getIDReferences().createID(this.id);
            if (area instanceof BlockArea) {
                area.end();
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        this.areaContainer = new AreaContainer(this.fs, -area.borderWidthLeft, -area.borderWidthTop, area.getAllocationWidth(), area.spaceLeft(), 2);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            object = (TableRow)this.children.elementAt(n2);
            ((TableRow)object).setColumns(this.columns);
            Status status = ((TableRow)object).layout(this.areaContainer);
            if (status.isIncomplete()) {
                this.marker = n2;
                if (n2 != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                area.addChild(this.areaContainer);
                area.increaseHeight(this.areaContainer.getHeight());
                area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                return status;
            }
            ++n2;
        }
        area.addChild(this.areaContainer);
        this.areaContainer.end();
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableBody(fObj, propertyList);
        }
    }
}

