/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.FontState;

public class TableColumn
extends FObj {
    FontState fs;
    ColorType backgroundColor;
    ColorType borderTopColor;
    int borderTopWidth;
    int borderTopStyle;
    ColorType borderBottomColor;
    int borderBottomWidth;
    int borderBottomStyle;
    ColorType borderLeftColor;
    int borderLeftWidth;
    int borderLeftStyle;
    ColorType borderRightColor;
    int borderRightWidth;
    int borderRightStyle;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int columnWidth;
    int columnOffset;
    AreaContainer areaContainer;

    public TableColumn(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-column";
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public Status layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n);
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.borderBottomColor = this.borderTopColor = this.properties.get("border-color").getColorType();
            this.borderLeftColor = this.borderTopColor;
            this.borderRightColor = this.borderTopColor;
            if (this.borderTopColor == null) {
                this.borderTopColor = this.properties.get("border-top-color").getColorType();
                this.borderBottomColor = this.properties.get("border-bottom-color").getColorType();
                this.borderLeftColor = this.properties.get("border-left-color").getColorType();
                this.borderRightColor = this.properties.get("border-right-color").getColorType();
            }
            this.borderBottomWidth = this.borderTopWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderLeftWidth = this.borderTopWidth;
            this.borderRightWidth = this.borderTopWidth;
            if (this.borderTopWidth == 0) {
                this.borderTopWidth = this.properties.get("border-top-width").getLength().mvalue();
                this.borderBottomWidth = this.properties.get("border-bottom-width").getLength().mvalue();
                this.borderLeftWidth = this.properties.get("border-left-width").getLength().mvalue();
                this.borderRightWidth = this.properties.get("border-right-width").getLength().mvalue();
            }
            this.borderBottomStyle = this.borderTopStyle = this.properties.get("border-style").getEnum();
            this.borderLeftStyle = this.borderTopStyle;
            this.borderRightStyle = this.borderTopStyle;
            if (this.borderTopStyle == 0) {
                this.borderTopStyle = this.properties.get("border-top-style").getEnum();
                this.borderBottomStyle = this.properties.get("border-bottom-style").getEnum();
                this.borderLeftStyle = this.properties.get("border-left-style").getEnum();
                this.borderRightStyle = this.properties.get("border-right-style").getEnum();
            }
            this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
            this.paddingRight = this.paddingTop;
            this.paddingBottom = this.paddingTop;
            if (this.paddingTop == 0) {
                this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
                this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
                this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
                this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
            }
            this.columnWidth = this.properties.get("column-width").getLength().mvalue();
            String string4 = this.properties.get("id").getString();
            area.getIDReferences().initializeID(string4, area);
        }
        this.areaContainer = new AreaContainer(this.fs, this.columnOffset - area.borderWidthLeft, -area.borderWidthTop, this.columnWidth, area.getHeight(), 2);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderTopStyle, this.borderLeftStyle, this.borderBottomStyle, this.borderRightStyle);
        this.areaContainer.setBorderWidth(this.borderTopWidth, this.borderLeftWidth, this.borderBottomWidth, this.borderRightWidth);
        this.areaContainer.setBorderColor(this.borderTopColor, this.borderLeftColor, this.borderBottomColor, this.borderRightColor);
        this.areaContainer.setHeight(area.getHeight());
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setColumnOffset(int n) {
        this.columnOffset = n;
    }

    public void setHeight(int n) {
        this.areaContainer.setMaxHeight(n);
        this.areaContainer.setHeight(n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableColumn(fObj, propertyList);
        }
    }
}

