/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;

public class TableRow
extends FObj {
    FontState fs;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    String id;
    ColorType borderTopColor;
    int borderTopWidth;
    int borderTopStyle;
    ColorType borderBottomColor;
    int borderBottomWidth;
    int borderBottomStyle;
    ColorType borderLeftColor;
    int borderLeftWidth;
    int borderLeftStyle;
    ColorType borderRightColor;
    int borderRightWidth;
    int borderRightStyle;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int widthOfCellsSoFar = 0;
    int largestCellHeight = 0;
    Vector columns;
    AreaContainer areaContainer;

    public TableRow(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-row";
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public Status layout(Area area) throws FOPException {
        int n;
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.borderBottomColor = this.borderTopColor = this.properties.get("border-color").getColorType();
            this.borderLeftColor = this.borderTopColor;
            this.borderRightColor = this.borderTopColor;
            if (this.borderTopColor == null) {
                this.borderTopColor = this.properties.get("border-top-color").getColorType();
                this.borderBottomColor = this.properties.get("border-bottom-color").getColorType();
                this.borderLeftColor = this.properties.get("border-left-color").getColorType();
                this.borderRightColor = this.properties.get("border-right-color").getColorType();
            }
            this.borderBottomWidth = this.borderTopWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderLeftWidth = this.borderTopWidth;
            this.borderRightWidth = this.borderTopWidth;
            if (this.borderTopWidth == 0) {
                this.borderTopWidth = this.properties.get("border-top-width").getLength().mvalue();
                this.borderBottomWidth = this.properties.get("border-bottom-width").getLength().mvalue();
                this.borderLeftWidth = this.properties.get("border-left-width").getLength().mvalue();
                this.borderRightWidth = this.properties.get("border-right-width").getLength().mvalue();
            }
            this.borderBottomStyle = this.borderTopStyle = this.properties.get("border-style").getEnum();
            this.borderLeftStyle = this.borderTopStyle;
            this.borderRightStyle = this.borderTopStyle;
            if (this.borderTopStyle == 0) {
                this.borderTopStyle = this.properties.get("border-top-style").getEnum();
                this.borderBottomStyle = this.properties.get("border-bottom-style").getEnum();
                this.borderLeftStyle = this.properties.get("border-left-style").getEnum();
                this.borderRightStyle = this.properties.get("border-right-style").getEnum();
            }
            this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
            this.paddingRight = this.paddingTop;
            this.paddingBottom = this.paddingTop;
            if (this.paddingTop == 0) {
                this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
                this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
                this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
                this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
            }
            this.id = this.properties.get("id").getString();
            if (area instanceof BlockArea) {
                area.end();
            }
            area.getIDReferences().createID(this.id);
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        this.areaContainer = new AreaContainer(this.fs, -area.borderWidthLeft, -area.borderWidthTop, area.getAllocationWidth(), area.spaceLeft(), 2);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderTopStyle, this.borderLeftStyle, this.borderBottomStyle, this.borderRightStyle);
        this.areaContainer.setBorderWidth(this.borderTopWidth, this.borderLeftWidth, this.borderBottomWidth, this.borderRightWidth);
        this.areaContainer.setBorderColor(this.borderTopColor, this.borderLeftColor, this.borderBottomColor, this.borderRightColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        int n2 = this.children.size();
        if (n2 != this.columns.size()) {
            MessageHandler.errorln("WARNING: Number of children under table-row not equal to number of table-columns");
            return new Status(1);
        }
        this.widthOfCellsSoFar = 0;
        this.largestCellHeight = 0;
        int n3 = this.marker;
        while (n3 < n2) {
            object = (TableCell)this.children.elementAt(n3);
            ((TableCell)object).setStartOffset(this.widthOfCellsSoFar);
            n = ((TableColumn)this.columns.elementAt(n3)).getColumnWidth();
            ((TableCell)object).setWidth(n);
            this.widthOfCellsSoFar += n;
            Status status = ((TableCell)object).layout(this.areaContainer);
            if (status.isIncomplete()) {
                this.marker = n3;
                if (n3 != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                area.removeChild(this.areaContainer);
                this.resetMarker();
                this.removeID(area.getIDReferences());
                return status;
            }
            int n4 = ((TableCell)object).getHeight();
            if (n4 > this.largestCellHeight) {
                this.largestCellHeight = n4;
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < n2) {
            TableCell tableCell = (TableCell)this.children.elementAt(n5);
            tableCell.setHeight(this.largestCellHeight);
            ++n5;
        }
        area.addChild(this.areaContainer);
        this.areaContainer.end();
        area.addDisplaySpace(this.largestCellHeight + this.areaContainer.getPaddingTop() + this.areaContainer.borderWidthTop + this.areaContainer.getPaddingBottom() + this.areaContainer.borderWidthBottom);
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableRow(fObj, propertyList);
        }
    }
}

