/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.PageMaster;
import org.apache.fop.messaging.MessageHandler;

public class PageSequence
extends FObj {
    private static final int EXPLICIT = 0;
    private static final int AUTO = 1;
    private static final int AUTO_EVEN = 2;
    private static final int AUTO_ODD = 3;
    private Root root;
    private LayoutMasterSet layoutMasterSet;
    private Hashtable _flowMap;
    private String masterName;
    private Page currentPage;
    private int currentPageNumber = 0;
    private static int runningPageNumberCounter = 0;
    private int pageNumberType;
    private boolean thisIsFirstPage;
    private SubSequenceSpecifier currentSubsequence;
    private int currentSubsequenceNumber = -1;
    private String currentPageMasterName;

    protected PageSequence(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:page-sequence";
        if (!fObj.getName().equals("fo:root")) {
            throw new FOPException("page-sequence must be child of root, not " + fObj.getName());
        }
        runningPageNumberCounter = 0;
        this.root = (Root)fObj;
        this.root.addPageSequence(this);
        this.layoutMasterSet = this.root.getLayoutMasterSet();
        this.layoutMasterSet.checkRegionNames();
        this._flowMap = new Hashtable();
        this.thisIsFirstPage = true;
        String string = this.properties.get("initial-page-number").getString();
        if (string.equals("auto")) {
            this.pageNumberType = 1;
        } else if (string.equals("auto-even")) {
            this.pageNumberType = 2;
        } else if (string.equals("auto-odd")) {
            this.pageNumberType = 3;
        } else {
            this.pageNumberType = 0;
            try {
                int n = new Integer(string);
                this.currentPageNumber = n > 0 ? n - 1 : 0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FOPException("\"" + string + "\" is not a valid value for initial-page-number");
            }
        }
        this.masterName = this.properties.get("master-name").getString();
    }

    public void addFlow(Flow flow) throws FOPException {
        if (this._flowMap.containsKey(flow.getFlowName())) {
            throw new FOPException("flow-names must be unique within an fo:page-sequence");
        }
        if (!this.layoutMasterSet.regionNameExists(flow.getFlowName())) {
            MessageHandler.errorln("WARNING: region-name '" + flow.getFlowName() + "' doesn't exist in the layout-master-set.");
        }
        this._flowMap.put(flow.getFlowName(), flow);
    }

    private boolean flowsAreIncomplete() {
        boolean bl = false;
        Enumeration enumeration = this._flowMap.elements();
        while (enumeration.hasMoreElements()) {
            Flow flow = (Flow)enumeration.nextElement();
            if (flow instanceof StaticContent) continue;
            Status status = flow.getStatus();
            bl |= status.isIncomplete();
        }
        return bl;
    }

    public void format(AreaTree areaTree) throws FOPException {
        Status status = new Status(1);
        this.layoutMasterSet.resetPageMasters();
        do {
            int n = runningPageNumberCounter;
            boolean bl = false;
            if (this.thisIsFirstPage) {
                bl = this.thisIsFirstPage;
                if (this.pageNumberType == 1) {
                    this.currentPageNumber = runningPageNumberCounter;
                } else if (this.pageNumberType == 3) {
                    this.currentPageNumber = runningPageNumberCounter;
                    if (this.currentPageNumber % 2 == 1) {
                        ++this.currentPageNumber;
                    }
                } else if (this.pageNumberType == 2) {
                    this.currentPageNumber = runningPageNumberCounter;
                    if (this.currentPageNumber % 2 == 0) {
                        ++this.currentPageNumber;
                    }
                }
                this.thisIsFirstPage = false;
            }
            ++this.currentPageNumber;
            boolean bl2 = false;
            bl2 = status.getCode() == 5 && this.currentPageNumber % 2 == 1 ? true : status.getCode() == 6 && this.currentPageNumber % 2 == 0;
            this.currentPage = this.makePage(areaTree, n, bl, bl2);
            this.currentPage.setNumber(this.currentPageNumber);
            runningPageNumberCounter = this.currentPageNumber;
            MessageHandler.log(" [" + this.currentPageNumber);
            this.formatStaticContent(areaTree);
            if (!(status.getCode() == 5 && this.currentPageNumber % 2 == 1 || status.getCode() == 6 && this.currentPageNumber % 2 == 0)) {
                AreaContainer areaContainer = this.currentPage.getBody();
                areaContainer.setIDReferences(areaTree.getIDReferences());
                Flow flow = this.getCurrentFlow("body");
                if (flow == null) {
                    MessageHandler.errorln("No flow found for region-body in page-master '" + this.currentPageMasterName + "'");
                    break;
                }
                status = flow.layout(areaContainer);
            }
            MessageHandler.log("]");
            areaTree.addPage(this.currentPage);
        } while (this.flowsAreIncomplete());
        MessageHandler.errorln("");
    }

    private void formatStaticContent(AreaTree areaTree) throws FOPException {
        AreaContainer areaContainer;
        Flow flow;
        SimplePageMaster simplePageMaster = this.getCurrentSimplePageMaster();
        if (simplePageMaster.getRegion("before") != null && this.currentPage.getBefore() != null && (flow = (Flow)this._flowMap.get(simplePageMaster.getRegion("before").getRegionName())) != null) {
            areaContainer = this.currentPage.getBefore();
            areaContainer.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(flow, simplePageMaster.getRegion("before"), areaContainer);
        }
        if (simplePageMaster.getRegion("after") != null && this.currentPage.getAfter() != null && (flow = (Flow)this._flowMap.get(simplePageMaster.getRegion("after").getRegionName())) != null) {
            areaContainer = this.currentPage.getAfter();
            areaContainer.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(flow, simplePageMaster.getRegion("after"), areaContainer);
        }
    }

    private Flow getCurrentFlow(String string) {
        Region region = this.getCurrentSimplePageMaster().getRegion(string);
        if (region != null) {
            Flow flow = (Flow)this._flowMap.get(region.getRegionName());
            return flow;
        }
        System.out.println("flow is null. regionClass = '" + string + "' currentSPM = " + this.getCurrentSimplePageMaster());
        return null;
    }

    private String getCurrentPageMasterName() {
        return this.currentPageMasterName;
    }

    private SimplePageMaster getCurrentSimplePageMaster() {
        return this.layoutMasterSet.getSimplePageMaster(this.currentPageMasterName);
    }

    private PageMaster getNextPageMaster(String string, int n, boolean bl, boolean bl2) throws FOPException {
        PageMaster pageMaster = null;
        PageSequenceMaster pageSequenceMaster = this.layoutMasterSet.getPageSequenceMaster(string);
        if (pageSequenceMaster != null) {
            pageMaster = this.getNextSimplePageMaster(pageSequenceMaster, n, bl, bl2).getPageMaster();
        } else {
            SimplePageMaster simplePageMaster = this.layoutMasterSet.getSimplePageMaster(string);
            if (simplePageMaster == null) {
                throw new FOPException("'master-name' for 'fo:page-sequence'matches no 'simple-page-master' or 'page-sequence-master'");
            }
            this.currentPageMasterName = string;
            pageMaster = simplePageMaster.getNextPageMaster();
        }
        return pageMaster;
    }

    private String getNextPageMasterName(PageSequenceMaster pageSequenceMaster, int n, boolean bl, boolean bl2) {
        String string;
        if (this.currentSubsequence == null) {
            this.currentSubsequence = this.getNextSubsequence(pageSequenceMaster);
        }
        if ((string = this.currentSubsequence.getNextPageMaster(n, bl, bl2)) == null || this.isFlowForMasterNameDone(this.currentPageMasterName)) {
            SubSequenceSpecifier subSequenceSpecifier = this.getNextSubsequence(pageSequenceMaster);
            if (subSequenceSpecifier == null) {
                MessageHandler.errorln("\nWARNING: Page subsequences exhausted. Using previous subsequence.");
                bl = true;
                this.currentSubsequence.reset();
            } else {
                this.currentSubsequence = subSequenceSpecifier;
            }
            string = this.currentSubsequence.getNextPageMaster(n, bl, bl2);
        }
        this.currentPageMasterName = string;
        return string;
    }

    private SimplePageMaster getNextSimplePageMaster(PageSequenceMaster pageSequenceMaster, int n, boolean bl, boolean bl2) {
        String string = this.getNextPageMasterName(pageSequenceMaster, n, bl, bl2);
        return this.layoutMasterSet.getSimplePageMaster(string);
    }

    private SubSequenceSpecifier getNextSubsequence(PageSequenceMaster pageSequenceMaster) {
        if (pageSequenceMaster.getSubSequenceSpecifierCount() > this.currentSubsequenceNumber + 1) {
            this.currentSubsequence = pageSequenceMaster.getSubSequenceSpecifier(this.currentSubsequenceNumber + 1);
            ++this.currentSubsequenceNumber;
            return this.currentSubsequence;
        }
        return null;
    }

    private boolean isFlowForMasterNameDone(String string) {
        if (string != null) {
            SimplePageMaster simplePageMaster = this.layoutMasterSet.getSimplePageMaster(string);
            Region region = simplePageMaster.getRegion("body");
            Flow flow = (Flow)this._flowMap.get(region.getRegionName());
            return flow != null && !flow.getStatus().isIncomplete();
        }
        return false;
    }

    private void layoutStaticContent(Flow flow, Region region, AreaContainer areaContainer) throws FOPException {
        if (flow instanceof StaticContent) {
            AreaContainer areaContainer2 = this.currentPage.getBefore();
            ((StaticContent)flow).layout(areaContainer, region);
        } else {
            MessageHandler.errorln("WARNING: " + region.getName() + " only supports static-content flows currently. Cannot use flow named '" + flow.getFlowName() + "'");
        }
    }

    private Page makePage(AreaTree areaTree, int n, boolean bl, boolean bl2) throws FOPException {
        PageMaster pageMaster = this.getNextPageMaster(this.masterName, n, bl, bl2);
        if (pageMaster == null) {
            throw new FOPException("page masters exhausted. Cannot recover.");
        }
        return pageMaster.makePage(areaTree);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageSequence(fObj, propertyList);
        }
    }
}

