/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.PageMaster;
import org.apache.fop.messaging.MessageHandler;

public class SimplePageMaster
extends FObj {
    private Hashtable _regions;
    LayoutMasterSet layoutMasterSet;
    PageMaster pageMaster;
    String masterName;

    protected SimplePageMaster(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:simple-page-master";
        if (fObj.getName().equals("fo:layout-master-set")) {
            this.layoutMasterSet = (LayoutMasterSet)fObj;
            this.masterName = this.properties.get("master-name").getString();
            if (this.masterName == null) {
                MessageHandler.errorln("WARNING: simple-page-master does not have a master-name and so is being ignored");
            } else {
                this.layoutMasterSet.addSimplePageMaster(this);
            }
        } else {
            throw new FOPException("fo:simple-page-master must be child of fo:layout-master-set, not " + fObj.getName());
        }
        this._regions = new Hashtable();
    }

    protected void addRegion(Region region) throws FOPException {
        if (this._regions.containsKey(region.getRegionClass())) {
            throw new FOPException("Only one region of class " + region.getRegionClass() + " allowed within a simple-page-master.");
        }
        this._regions.put(region.getRegionClass(), region);
    }

    protected void end() {
        int n = this.properties.get("page-width").getLength().mvalue();
        int n2 = this.properties.get("page-height").getLength().mvalue();
        int n3 = this.properties.get("margin-top").getLength().mvalue();
        int n4 = this.properties.get("margin-bottom").getLength().mvalue();
        int n5 = this.properties.get("margin-left").getLength().mvalue();
        int n6 = this.properties.get("margin-right").getLength().mvalue();
        int n7 = n5;
        int n8 = n2 - n3;
        int n9 = n - n5 - n6;
        int n10 = n2 - n3 - n4;
        this.pageMaster = new PageMaster(n, n2);
        if (this.getRegion("body") != null) {
            this.pageMaster.addBody(this.getRegion("body").makeRegionArea(n7, n8, n9, n10));
        } else {
            MessageHandler.errorln("ERROR: simple-page-master must have a region of class body");
        }
        if (this.getRegion("before") != null) {
            this.pageMaster.addBefore(this.getRegion("before").makeRegionArea(n7, n8, n9, n10));
        }
        if (this.getRegion("after") != null) {
            this.pageMaster.addAfter(this.getRegion("after").makeRegionArea(n7, n8, n9, n10));
        }
    }

    public String getMasterName() {
        return this.masterName;
    }

    public PageMaster getNextPageMaster() {
        return this.pageMaster;
    }

    public PageMaster getPageMaster() {
        return this.pageMaster;
    }

    protected Region getRegion(String string) {
        return (Region)this._regions.get(string);
    }

    protected Hashtable getRegions() {
        return this._regions;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected boolean regionNameExists(String string) {
        Enumeration enumeration = this._regions.elements();
        while (enumeration.hasMoreElements()) {
            Region region = (Region)enumeration.nextElement();
            if (!region.getRegionName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new SimplePageMaster(fObj, propertyList);
        }
    }
}

