/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Space;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.SpaceProperty;
import org.apache.fop.fo.StringProperty;

public class GenericSpace
extends SpaceProperty.Maker {
    private static final Property.Maker s_minimumMaker = new LengthProperty.Maker("generic-space.minimum");
    private static final Property.Maker s_optimumMaker = new LengthProperty.Maker("generic-space.optimum");
    private static final Property.Maker s_maximumMaker = new LengthProperty.Maker("generic-space.maximum");
    private static final Property.Maker s_precedenceMaker = new NumberProperty.Maker("generic-space.precedence");
    private static final Property.Maker s_conditionalityMaker = new StringProperty.Maker("generic-space.conditionality");
    private Property m_defaultProp = null;

    protected GenericSpace(String string) {
        super(string);
    }

    protected Property.Maker getSubpropMaker(String string) {
        if (string.equals("minimum")) {
            return s_minimumMaker;
        }
        if (string.equals("optimum")) {
            return s_optimumMaker;
        }
        if (string.equals("maximum")) {
            return s_maximumMaker;
        }
        if (string.equals("precedence")) {
            return s_precedenceMaker;
        }
        if (string.equals("conditionality")) {
            return s_conditionalityMaker;
        }
        return super.getSubpropMaker(string);
    }

    public Property getSubpropValue(Property property, String string) {
        Space space = ((SpaceProperty)property).getSpace();
        if (string.equals("minimum")) {
            return new LengthProperty(space.getMinimum());
        }
        if (string.equals("optimum")) {
            return new LengthProperty(space.getOptimum());
        }
        if (string.equals("maximum")) {
            return new LengthProperty(space.getMaximum());
        }
        if (string.equals("precedence")) {
            return new NumberProperty(space.getPrecedence());
        }
        if (string.equals("conditionality")) {
            return new StringProperty(space.getConditionality());
        }
        return super.getSubpropValue(property, string);
    }

    public boolean isInherited() {
        return false;
    }

    public Property make(PropertyList propertyList, boolean bl) throws FOPException {
        if (bl) {
            return this.make(propertyList, "0pt", null);
        }
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.make(propertyList, "0pt", null);
        }
        return this.m_defaultProp;
    }

    public static Property.Maker maker(String string) {
        return new GenericSpace(string);
    }

    protected Property setSubprop(Property property, String string, Property property2) {
        Space space = ((SpaceProperty)property).getSpace();
        if (string.equals("minimum")) {
            space.setMinimum(property2.getLength());
        } else if (string.equals("optimum")) {
            space.setOptimum(property2.getLength());
        } else if (string.equals("maximum")) {
            space.setMaximum(property2.getLength());
        } else if (string.equals("precedence")) {
            space.setPrecedence(property2.getNumber());
        } else if (string.equals("conditionality")) {
            space.setConditionality(property2.getString());
        } else {
            return super.setSubprop(property, string, property2);
        }
        return property;
    }
}

