/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.fonts.PFMInputStream;

public class PFMFile {
    private String windowsName;
    private String postscriptName;
    private short dfItalic;
    private int dfWeight;
    private short dfCharSet;
    private short dfPitchAndFamily;
    private int dfAvgWidth;
    private int dfMaxWidth;
    private int dfMinWidth;
    private short dfFirstChar;
    private short dfLastChar;
    private int etmCapHeight;
    private int etmXHeight;
    private int etmLowerCaseAscent;
    private int etmLowerCaseDescent;
    private int[] extentTable;

    public int getCapHeight() {
        return this.etmCapHeight;
    }

    public short getCharSet() {
        return this.dfCharSet;
    }

    public String getCharSetName() {
        switch (this.dfCharSet) {
            case 0: {
                return "WinAnsi";
            }
            case 128: {
                return "Shift-JIS (Japanese)";
            }
        }
        return "Unknown";
    }

    public int getCharWidth(short s) {
        return this.extentTable[s - this.dfFirstChar];
    }

    public short getFirstChar() {
        return this.dfFirstChar;
    }

    public int getFlags() {
        int n = 0;
        if (!this.getIsProportional()) {
            n |= 1;
        }
        if ((this.dfPitchAndFamily & 0x10) == 16) {
            n |= 2;
        }
        if ((this.dfPitchAndFamily & 0x40) == 64) {
            n |= 4;
        }
        if (this.dfCharSet == 0) {
            n |= 6;
        }
        if (this.dfItalic != 0) {
            n |= 7;
        }
        return n;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{!this.getIsProportional() && this.dfAvgWidth == this.dfMaxWidth ? -20 : -100, -(this.getLowerCaseDescent() + 5), this.dfMaxWidth + 10, this.getLowerCaseAscent() + 5};
        return nArray;
    }

    public boolean getIsProportional() {
        return (this.dfPitchAndFamily & 1) == 1;
    }

    public int getItalicAngle() {
        if (this.dfItalic != 0) {
            return -16;
        }
        return 0;
    }

    public short getLastChar() {
        return this.dfLastChar;
    }

    public int getLowerCaseAscent() {
        return this.etmLowerCaseAscent;
    }

    public int getLowerCaseDescent() {
        return this.etmLowerCaseDescent;
    }

    public String getPostscriptName() {
        return this.postscriptName;
    }

    public int getStemV() {
        if (this.dfItalic != 0) {
            return (int)Math.round((double)this.dfMinWidth * 0.25);
        }
        return (int)Math.round((double)this.dfMinWidth * 0.6);
    }

    public String getWindowsName() {
        return this.windowsName;
    }

    public int getXHeight() {
        return this.etmXHeight;
    }

    public void load(InputStream inputStream) throws IOException {
        InputStream inputStream2 = new BufferedInputStream(inputStream, 1024);
        ((InputStream)inputStream2).mark(1024);
        PFMInputStream pFMInputStream = new PFMInputStream(inputStream2);
        int n = pFMInputStream.readShort();
        long l = pFMInputStream.readInt();
        ((InputStream)inputStream2).reset();
        byte[] byArray = new byte[(int)l];
        ((InputStream)inputStream2).read(byArray, 0, (int)l);
        inputStream2 = new ByteArrayInputStream(byArray);
        pFMInputStream = new PFMInputStream(inputStream2);
        this.loadHeader(pFMInputStream);
        this.loadExtension(pFMInputStream);
    }

    private void loadExtMetrics(PFMInputStream pFMInputStream) throws IOException {
        int n = pFMInputStream.readShort();
        pFMInputStream.skip(12L);
        this.etmCapHeight = pFMInputStream.readShort();
        this.etmXHeight = pFMInputStream.readShort();
        this.etmLowerCaseAscent = pFMInputStream.readShort();
        this.etmLowerCaseDescent = pFMInputStream.readShort();
    }

    private void loadExtension(PFMInputStream pFMInputStream) throws IOException {
        int n = pFMInputStream.readShort();
        long l = pFMInputStream.readInt();
        long l2 = pFMInputStream.readInt();
        pFMInputStream.skip(12L);
        long l3 = pFMInputStream.readInt();
        pFMInputStream.reset();
        pFMInputStream.skip(l3);
        this.postscriptName = pFMInputStream.readString();
        if (l != 0L) {
            pFMInputStream.reset();
            pFMInputStream.skip(l);
            this.loadExtMetrics(pFMInputStream);
        }
        if (l2 != 0L) {
            pFMInputStream.reset();
            pFMInputStream.skip(l2);
            this.loadExtentTable(pFMInputStream);
        }
    }

    private void loadExtentTable(PFMInputStream pFMInputStream) throws IOException {
        this.extentTable = new int[this.dfLastChar - this.dfFirstChar];
        this.dfMinWidth = this.dfMaxWidth;
        short s = this.dfFirstChar;
        while (s < this.dfLastChar) {
            this.extentTable[s - this.dfFirstChar] = pFMInputStream.readShort();
            if (this.extentTable[s - this.dfFirstChar] < this.dfMinWidth) {
                this.dfMinWidth = this.extentTable[s - this.dfFirstChar];
            }
            s = (short)(s + 1);
        }
    }

    private void loadHeader(PFMInputStream pFMInputStream) throws IOException {
        pFMInputStream.skip(80L);
        this.dfItalic = pFMInputStream.readByte();
        pFMInputStream.skip(2L);
        this.dfWeight = pFMInputStream.readShort();
        this.dfCharSet = pFMInputStream.readByte();
        pFMInputStream.skip(4L);
        this.dfPitchAndFamily = pFMInputStream.readByte();
        this.dfAvgWidth = pFMInputStream.readShort();
        this.dfMaxWidth = pFMInputStream.readShort();
        this.dfFirstChar = pFMInputStream.readByte();
        this.dfLastChar = pFMInputStream.readByte();
        pFMInputStream.skip(8L);
        long l = pFMInputStream.readInt();
        pFMInputStream.reset();
        pFMInputStream.skip(l);
        this.windowsName = pFMInputStream.readString();
        pFMInputStream.reset();
        pFMInputStream.skip(117L);
    }
}

