/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.apache.fop.fonts.PFMFile;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PFMReader {
    private static final String XSL_POSTPROCESS = "FontPostProcess.xsl";
    private static final String XSL_SORT = "FontPostProcessSort.xsl";
    private boolean invokedStandalone = false;

    public Document constructFontXML(PFMFile pFMFile) {
        Comparable<StringBuffer> comparable;
        System.out.println("Creating xml font file...");
        System.out.println();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("font-metrics");
        documentImpl.appendChild(element);
        Element element2 = documentImpl.createElement("font-name");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode(pFMFile.getPostscriptName()));
        String string = pFMFile.getPostscriptName();
        int n = string.indexOf("-");
        if (n >= 0) {
            comparable = new StringBuffer(string);
            ((StringBuffer)comparable).deleteCharAt(n);
            string = ((StringBuffer)comparable).toString();
        }
        element2 = documentImpl.createElement("class-name");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode(string));
        element2 = documentImpl.createElement("subtype");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode("Type1"));
        element2 = documentImpl.createElement("encoding");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode(String.valueOf(pFMFile.getCharSetName()) + "Encoding"));
        element2 = documentImpl.createElement("cap-height");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getCapHeight());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("x-height");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getXHeight());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("ascender");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getLowerCaseAscent());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("descender");
        element.appendChild(element2);
        comparable = new Integer(-pFMFile.getLowerCaseDescent());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        Element element3 = documentImpl.createElement("bbox");
        element.appendChild(element3);
        int[] nArray = pFMFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        int n2 = 0;
        while (n2 < 4) {
            element2 = documentImpl.createElement(stringArray[n2]);
            element3.appendChild(element2);
            comparable = new Integer(nArray[n2]);
            element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
            ++n2;
        }
        element2 = documentImpl.createElement("flags");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getFlags());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("stemv");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getStemV());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("italicangle");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getItalicAngle());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("first-char");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getFirstChar());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        element2 = documentImpl.createElement("last-char");
        element.appendChild(element2);
        comparable = new Integer(pFMFile.getLastChar());
        element2.appendChild(documentImpl.createTextNode(((Integer)comparable).toString()));
        Element element4 = documentImpl.createElement("widths");
        element.appendChild(element4);
        short s = pFMFile.getFirstChar();
        while (s < pFMFile.getLastChar()) {
            element2 = documentImpl.createElement("char");
            element4.appendChild(element2);
            element2.setAttribute("ansichar", "0x00" + Integer.toHexString(s).toUpperCase());
            element2.setAttribute("width", new Integer(pFMFile.getCharWidth(s)).toString());
            s = (short)(s + 1);
        }
        return documentImpl;
    }

    public PFMFile loadPFM(String string) {
        try {
            System.out.println("Reading " + string + "...");
            System.out.println();
            FileInputStream fileInputStream = new FileInputStream(string);
            PFMFile pFMFile = new PFMFile();
            pFMFile.load(fileInputStream);
            return pFMFile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        PFMReader pFMReader = new PFMReader();
        pFMReader.invokedStandalone = true;
        System.out.println("PFM Reader v1.0");
        System.out.println();
        if (stringArray.length > 0) {
            PFMFile pFMFile = pFMReader.loadPFM(stringArray[0]);
            if (pFMFile != null) {
                pFMReader.preview(pFMFile);
                if (stringArray.length > 1) {
                    Document document = pFMReader.constructFontXML(pFMFile);
                    if ((document = pFMReader.postProcessXML(document)) != null) {
                        pFMReader.writeFontXML(document, stringArray[1]);
                    }
                }
            }
        } else {
            System.out.println("Arguments: <source> [<target>]");
            System.out.println("Example: COM_____.pfm COM_____.xml");
        }
    }

    public Document postProcessXML(Document document) {
        try {
            System.out.println("Postprocessing...");
            System.out.println();
            XSLTInputSource xSLTInputSource = new XSLTInputSource((Node)document);
            InputStream inputStream = this.getClass().getResourceAsStream(XSL_POSTPROCESS);
            if (inputStream == null) {
                throw new Exception("Resource FontPostProcess.xsl not found");
            }
            XSLTInputSource xSLTInputSource2 = new XSLTInputSource(inputStream);
            DocumentImpl documentImpl = new DocumentImpl();
            XSLTResultTarget xSLTResultTarget = new XSLTResultTarget((Node)documentImpl);
            XSLTProcessor xSLTProcessor = XSLTProcessorFactory.getProcessor((XMLParserLiaison)new XercesLiaison());
            xSLTProcessor.process(xSLTInputSource, xSLTInputSource2, xSLTResultTarget);
            System.out.println("Sorting...");
            System.out.println();
            xSLTInputSource.setNode((Node)documentImpl);
            inputStream = this.getClass().getResourceAsStream(XSL_SORT);
            if (inputStream == null) {
                throw new Exception("Resource FontPostProcessSort.xsl not found");
            }
            xSLTInputSource2 = new XSLTInputSource(inputStream);
            DocumentImpl documentImpl2 = new DocumentImpl();
            xSLTResultTarget = new XSLTResultTarget((Node)documentImpl2);
            xSLTProcessor.process(xSLTInputSource, xSLTInputSource2, xSLTResultTarget);
            return documentImpl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void preview(PFMFile pFMFile) {
        PrintStream printStream = System.out;
        printStream.print("Font: ");
        printStream.println(pFMFile.getWindowsName());
        printStream.print("Name: ");
        printStream.println(pFMFile.getPostscriptName());
        printStream.print("CharSet: ");
        printStream.println(pFMFile.getCharSetName());
        printStream.print("CapHeight: ");
        printStream.println(pFMFile.getCapHeight());
        printStream.print("XHeight: ");
        printStream.println(pFMFile.getXHeight());
        printStream.print("LowerCaseAscent: ");
        printStream.println(pFMFile.getLowerCaseAscent());
        printStream.print("LowerCaseDescent: ");
        printStream.println(pFMFile.getLowerCaseDescent());
        printStream.print("Having widths for ");
        printStream.print(pFMFile.getLastChar() - pFMFile.getFirstChar());
        printStream.print(" characters (");
        printStream.print(pFMFile.getFirstChar());
        printStream.print("-");
        printStream.print(pFMFile.getLastChar());
        printStream.println(").");
        printStream.print("for example: Char ");
        printStream.print(pFMFile.getFirstChar());
        printStream.print(" has a width of ");
        printStream.println(pFMFile.getCharWidth(pFMFile.getFirstChar()));
        printStream.println();
    }

    public void writeFontXML(Document document, String string) {
        System.out.println("Writing xml font file " + string + "...");
        System.out.println();
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            FileWriter fileWriter = new FileWriter(string);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document.getDocumentElement());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

