/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontMetric;

public class FontState {
    protected FontInfo fontInfo;
    private String fontName;
    private int fontSize;
    private String fontFamily;
    private String fontStyle;
    private String fontWeight;
    private FontMetric metric;

    public FontState(FontInfo fontInfo, String string, String string2, String string3, int n) throws FOPException {
        this.fontInfo = fontInfo;
        this.fontFamily = string;
        this.fontStyle = string2;
        this.fontWeight = string3;
        this.fontSize = n;
        this.fontName = fontInfo.fontLookup(string, string2, string3);
        this.metric = fontInfo.getMetricsFor(this.fontName);
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public int width(int n) {
        return this.metric.width(n, this.fontSize) / 1000;
    }
}

