/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.layout.LeaderArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.PageNumberInlineArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.CodePointMapping;

public class LineArea
extends Area {
    protected int lineHeight;
    protected int halfLeading;
    protected int nominalFontSize;
    protected int nominalGlyphHeight;
    protected int allocationHeight;
    protected int startIndent;
    protected int endIndent;
    private int placementOffset;
    private FontState currentFontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    protected int finalWidth = 0;
    protected int embeddedLinkStart = 0;
    protected int wordWidth = 0;
    protected static final int NOTHING = 0;
    protected static final int WHITESPACE = 1;
    protected static final int TEXT = 2;
    protected int prev = 0;
    protected int wordStart;
    protected int wordLength = 0;
    protected int spaceWidth = 0;
    protected Vector pendingAreas = new Vector();
    protected int pendingWidth = 0;

    public LineArea(FontState fontState, int n, int n2, int n3, int n4, int n5, LineArea lineArea) {
        super(fontState);
        this.currentFontState = fontState;
        this.lineHeight = n;
        this.nominalFontSize = fontState.getFontSize();
        this.nominalGlyphHeight = fontState.getAscender() - fontState.getDescender();
        this.placementOffset = fontState.getAscender();
        this.contentRectangleWidth = n3 - n4 - n5;
        this.fontState = fontState;
        this.allocationHeight = this.nominalGlyphHeight;
        this.halfLeading = this.lineHeight - this.allocationHeight;
        this.startIndent = n4;
        this.endIndent = n5;
        if (lineArea != null) {
            Enumeration enumeration = lineArea.pendingAreas.elements();
            while (enumeration.hasMoreElements()) {
                this.pendingAreas.addElement(enumeration.nextElement());
            }
            this.pendingWidth = lineArea.getPendingWidth();
        }
    }

    public void addLeader(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.getContentWidth() - this.getCurrentXPosition();
        int n10 = n9 < n4 ? n9 : n4;
        switch (n) {
            case 1: {
                int n11 = this.whiteSpaceCollapse;
                this.changeWhiteSpaceCollapse(2);
                this.pendingAreas.addElement(this.buildSimpleLeader(32, n10));
                this.changeWhiteSpaceCollapse(n11);
                break;
            }
            case 2: {
                LeaderArea leaderArea = new LeaderArea(this.fontState, this.red, this.green, this.blue, "", n10, n, n6, n5);
                this.pendingAreas.addElement(leaderArea);
                break;
            }
            case 3: {
                int n12;
                if (n7 < this.currentFontState.width(46)) {
                    n7 = 0;
                }
                if (n7 == 0) {
                    this.pendingAreas.addElement(this.buildSimpleLeader(46, n10));
                    break;
                }
                if (n8 == 2 && (n12 = this.getLeaderAlignIndent(n10, n7)) != 0) {
                    this.pendingAreas.addElement(new InlineSpace(n12, false));
                    this.pendingWidth += n12;
                    n10 -= n12;
                }
                InlineSpace inlineSpace = new InlineSpace(n7 - this.currentFontState.width(46), false);
                InlineArea inlineArea = new InlineArea(this.currentFontState, this.red, this.green, this.blue, new String("."), this.currentFontState.width(46));
                int n13 = (int)Math.floor((double)n10 / (double)n7);
                int n14 = 0;
                while (n14 < n13) {
                    this.pendingAreas.addElement(inlineArea);
                    this.pendingAreas.addElement(inlineSpace);
                    ++n14;
                }
                this.pendingAreas.addElement(new InlineSpace(n10 - n13 * n7));
                break;
            }
            case 4: {
                MessageHandler.errorln("leader-pattern=\"use-content\" not supported by this version of Fop");
                return;
            }
        }
        this.pendingWidth += n10;
        this.prev = 2;
    }

    public int addPageNumberCitation(String string, LinkSet linkSet) {
        int n = this.currentFontState.width(32) * 3;
        PageNumberInlineArea pageNumberInlineArea = new PageNumberInlineArea(this.currentFontState, this.red, this.green, this.blue, string, n);
        this.pendingAreas.addElement(pageNumberInlineArea);
        this.pendingWidth += n;
        this.wordWidth = 0;
        this.prev = 2;
        return -1;
    }

    public void addPending() {
        if (this.spaceWidth > 0) {
            this.addChild(new InlineSpace(this.spaceWidth));
            this.finalWidth += this.spaceWidth;
            this.spaceWidth = 0;
        }
        Enumeration enumeration = this.pendingAreas.elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            this.addChild(box);
        }
        this.finalWidth += this.pendingWidth;
        this.pendingWidth = 0;
        this.pendingAreas = new Vector();
    }

    public int addText(char[] cArray, int n, int n2, LinkSet linkSet, boolean bl) {
        boolean bl2 = false;
        this.wordStart = n;
        this.wordLength = 0;
        this.wordWidth = 0;
        char[] cArray2 = new char[cArray.length];
        int n3 = 0;
        while (n3 < cArray.length) {
            cArray2[n3] = cArray[n3];
            ++n3;
        }
        int n4 = n;
        while (n4 < n2) {
            int n5 = cArray2[n4];
            if (n5 > 127) {
                int n6 = CodePointMapping.map[n5];
                if (n6 != 0) {
                    n5 = cArray2[n4] = n6;
                } else {
                    MessageHandler.error("ch" + n5 + "?");
                    cArray2[n4] = 35;
                    n5 = 35;
                }
            }
            int n7 = this.currentFontState.width(n5);
            if (n5 == 32 || n5 == 10 || n5 == 13 || n5 == 9) {
                if (this.prev == 1) {
                    if (this.whiteSpaceCollapse == 2) {
                        if (n5 == 32) {
                            this.spaceWidth += this.currentFontState.width(32);
                        } else {
                            if (n5 == 10) {
                                return n4;
                            }
                            if (n5 == 9) {
                                this.spaceWidth += 8 * this.currentFontState.width(32);
                            }
                        }
                    }
                } else if (this.prev == 2) {
                    Rectangle rectangle;
                    Box box;
                    if (this.spaceWidth > 0) {
                        this.addChild(new InlineSpace(this.spaceWidth));
                        this.finalWidth += this.spaceWidth;
                        this.spaceWidth = 0;
                    }
                    Enumeration enumeration = this.pendingAreas.elements();
                    while (enumeration.hasMoreElements()) {
                        box = (Box)enumeration.nextElement();
                        if (box instanceof InlineArea && linkSet != null) {
                            rectangle = new Rectangle(this.finalWidth, 0, ((InlineArea)box).getContentWidth(), this.fontState.getFontSize());
                            linkSet.addRect(rectangle, this);
                        }
                        this.addChild(box);
                    }
                    this.finalWidth += this.pendingWidth;
                    this.pendingWidth = 0;
                    this.pendingAreas = new Vector();
                    if (this.wordLength > 0) {
                        box = new InlineArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray2, this.wordStart, this.wordLength), this.wordWidth);
                        ((InlineArea)box).setUnderlined(bl);
                        this.addChild(box);
                        if (linkSet != null) {
                            rectangle = new Rectangle(this.finalWidth, 0, ((Area)box).getContentWidth(), this.fontState.getFontSize());
                            linkSet.addRect(rectangle, this);
                        }
                        this.finalWidth += this.wordWidth;
                        this.wordWidth = 0;
                    }
                    this.prev = 1;
                    this.embeddedLinkStart = 0;
                    this.spaceWidth = this.currentFontState.width(32);
                    if (this.whiteSpaceCollapse == 2) {
                        if (n5 == 10) {
                            return n4;
                        }
                        if (n5 == 9) {
                            this.spaceWidth = this.currentFontState.width(32);
                        }
                    }
                } else if (this.whiteSpaceCollapse == 2) {
                    this.prev = 1;
                    this.spaceWidth = this.currentFontState.width(32);
                } else {
                    ++n;
                }
            } else {
                if (this.prev == 1) {
                    this.wordWidth = n7;
                    if (this.finalWidth + this.spaceWidth + this.wordWidth > this.getContentWidth()) {
                        if (bl2) {
                            MessageHandler.error(">");
                        }
                        if (this.wrapOption == 1) {
                            return n4;
                        }
                    }
                    this.prev = 2;
                    this.wordStart = n4;
                    this.wordLength = 1;
                } else if (this.prev == 2) {
                    ++this.wordLength;
                    this.wordWidth += n7;
                } else {
                    this.prev = 2;
                    this.wordStart = n4;
                    this.wordLength = 1;
                    this.wordWidth = n7;
                }
                if (this.finalWidth + this.spaceWidth + this.pendingWidth + this.wordWidth > this.getContentWidth()) {
                    if (this.wordStart == n) {
                        bl2 = true;
                        if (this.finalWidth > 0) {
                            return this.wordStart;
                        }
                    } else if (this.wrapOption == 1) {
                        return this.wordStart;
                    }
                }
            }
            ++n4;
        }
        if (this.prev == 2) {
            InlineArea inlineArea = new InlineArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray2, this.wordStart, this.wordLength), this.wordWidth);
            inlineArea.setUnderlined(bl);
            if (linkSet != null) {
                Rectangle rectangle = new Rectangle(this.finalWidth + this.spaceWidth + this.embeddedLinkStart, this.spaceWidth, inlineArea.getContentWidth(), this.fontState.getFontSize());
                linkSet.addRect(rectangle, this);
            }
            this.embeddedLinkStart += this.wordWidth;
            this.pendingAreas.addElement(inlineArea);
            this.pendingWidth += this.wordWidth;
            this.wordWidth = 0;
        }
        if (bl2) {
            MessageHandler.error(">");
        }
        return -1;
    }

    public void align(int n) {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = this.getContentWidth() - this.finalWidth;
                this.endIndent += n2;
                break;
            }
            case 2: {
                n2 = this.getContentWidth() - this.finalWidth;
                this.startIndent += n2;
                break;
            }
            case 1: {
                n2 = (this.getContentWidth() - this.finalWidth) / 2;
                this.startIndent += n2;
                this.endIndent += n2;
                break;
            }
            case 4: {
                InlineSpace inlineSpace;
                Object object;
                Vector<InlineSpace> vector = new Vector<InlineSpace>();
                int n3 = 0;
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Box)enumeration.nextElement();
                    if (!(object instanceof InlineSpace) || !(inlineSpace = (InlineSpace)object).getResizeable()) continue;
                    vector.addElement(inlineSpace);
                    ++n3;
                }
                n2 = n3 > 0 ? (this.getContentWidth() - this.finalWidth) / n3 : 0;
                object = vector.elements();
                while (object.hasMoreElements()) {
                    inlineSpace = (InlineSpace)object.nextElement();
                    int n4 = inlineSpace.getSize();
                    inlineSpace.setSize(n4 + n2);
                }
                break;
            }
        }
    }

    private InlineArea buildSimpleLeader(int n, int n2) {
        int n3 = (int)Math.floor(n2 / this.currentFontState.width(n));
        char[] cArray = new char[n3];
        char c = (char)n;
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = c;
            ++n4;
        }
        InlineArea inlineArea = new InlineArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray), n2);
        return inlineArea;
    }

    public void changeColor(float f, float f2, float f3) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
    }

    public void changeFont(FontState fontState) {
        this.currentFontState = fontState;
    }

    public void changeWhiteSpaceCollapse(int n) {
        this.whiteSpaceCollapse = n;
    }

    public void changeWrapOption(int n) {
        this.wrapOption = n;
    }

    private int getCurrentXPosition() {
        return this.finalWidth + this.spaceWidth + this.startIndent + this.pendingWidth;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getHeight() {
        return this.allocationHeight;
    }

    private int getLeaderAlignIndent(int n, int n2) {
        double d = this.getCurrentXPosition();
        double d2 = Math.ceil(d / (double)n2);
        double d3 = (double)n2 * d2 - d;
        return (int)d3;
    }

    public Vector getPendingAreas() {
        return this.pendingAreas;
    }

    public int getPendingWidth() {
        return this.pendingWidth;
    }

    public int getPlacementOffset() {
        return this.placementOffset;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public boolean isEmpty() {
        return this.prev == 0;
    }

    public void render(Renderer renderer) {
        renderer.renderLineArea(this);
    }

    public void setPendingAreas(Vector vector) {
        this.pendingAreas = vector;
    }

    public void setPendingWidth(int n) {
        this.pendingWidth = n;
    }
}

