/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Vector;
import java.util.zip.Deflater;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;

public class PDFBinaryStream {
    private byte[] m_data = null;
    private int m_dataSize = 0;
    private Vector m_filters = new Vector();

    public void encode(PDFFilter pDFFilter) throws PDFFilterException {
        if (this.m_data == null) {
            throw new PDFFilterException("no data to encode");
        }
        int n = pDFFilter.getType();
        if (n == PDFFilter.FLATE_DECODE) {
            Deflater deflater = new Deflater();
            deflater.setLevel(-1);
            deflater.setStrategy(0);
            deflater.setInput(this.m_data);
            deflater.finish();
            byte[] byArray = new byte[this.m_dataSize];
            int n2 = deflater.deflate(byArray);
            deflater.end();
            this.m_data = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.m_data[n3] = byArray[n3];
                ++n3;
            }
            this.m_dataSize = n2;
        } else if (n == PDFFilter.ASCII_HEX_DECODE) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < this.m_dataSize) {
                int n5 = this.m_data[n4] & 0xFF;
                if (n5 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n5));
                ++n4;
            }
            this.m_data = stringBuffer.toString().getBytes();
            this.m_dataSize = Array.getLength(this.m_data);
        } else {
            throw new PDFFilterException("filter not supported");
        }
        this.m_filters.addElement(pDFFilter);
    }

    public String getPDFDictionary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/Length ");
        stringBuffer.append(this.m_dataSize);
        stringBuffer.append("\n");
        if (this.m_filters.size() > 0) {
            stringBuffer.append("/Filter [");
            int n = this.m_filters.size();
            while (n > 0) {
                PDFFilter pDFFilter = (PDFFilter)this.m_filters.elementAt(n - 1);
                stringBuffer.append(pDFFilter.toPDF());
                if (n > 1) {
                    stringBuffer.append(" ");
                }
                --n;
            }
            stringBuffer.append("]\n");
        }
        return stringBuffer.toString();
    }

    public String getPDFStream() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("stream\n");
        stringBuffer.append(this.m_data);
        stringBuffer.append("\nendstream\n");
        return stringBuffer.toString();
    }

    public int outputPDFStream(PrintWriter printWriter) throws IOException {
        int n = 0;
        String string = new String("stream\n");
        printWriter.write(string);
        n += string.length();
        printWriter.write(new String(this.m_data));
        n += this.m_dataSize;
        string = new String("\nendstream\n");
        printWriter.write(string);
        return n += string.length();
    }

    public void setData(byte[] byArray) {
        this.m_data = byArray;
        this.m_dataSize = Array.getLength(this.m_data);
    }

    public String toPDF() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<<\n/Length ");
        stringBuffer.append(this.m_dataSize);
        stringBuffer.append("\n");
        stringBuffer.append("/Filter [");
        int n = this.m_filters.size();
        while (n > 0) {
            PDFFilter pDFFilter = (PDFFilter)this.m_filters.elementAt(n - 1);
            stringBuffer.append(pDFFilter.toPDF());
            if (n > 1) {
                stringBuffer.append(" ");
            }
            --n;
        }
        stringBuffer.append("]\n");
        stringBuffer.append(">>\n");
        stringBuffer.append("stream\n");
        stringBuffer.append(this.m_data);
        stringBuffer.append("\nendstream\n");
        return stringBuffer.toString();
    }
}

