/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFFilterException;

public class PDFFilter {
    public static int ASCII_HEX_DECODE = 1;
    public static int ASCII_85_DECODE = 2;
    public static int LZW_DECODE = 3;
    public static int RUN_LENGTH_DECODE = 4;
    public static int CCITT_FAX_DECODE = 5;
    public static int DCT_DECODE = 6;
    public static int FLATE_DECODE = 7;
    private int m_filterType;
    private Integer m_predictor = null;
    private Integer m_columns = null;
    private Integer m_colors = null;
    private Integer m_bitsPerComponent = null;
    private Integer m_earlyChange = null;
    private Integer m_k = null;
    private Boolean m_endOfLine = null;
    private Boolean m_encodedByteAlign = null;
    private Integer m_rows = null;
    private Boolean m_endOfBlock = null;
    private Boolean m_blackls1 = null;
    private Integer m_damagedRowsBeforeError = null;

    public PDFFilter(int n) throws PDFFilterException {
        if (n != ASCII_HEX_DECODE && n != ASCII_85_DECODE && n != LZW_DECODE && n != RUN_LENGTH_DECODE && n != CCITT_FAX_DECODE && n != DCT_DECODE && n != FLATE_DECODE) {
            throw new PDFFilterException("Filter type not supported");
        }
        this.m_filterType = n;
    }

    public Integer getPredictor() throws PDFFilterException {
        if (this.m_filterType != LZW_DECODE && this.m_filterType != FLATE_DECODE) {
            throw new PDFFilterException("No Predictor property for this filter");
        }
        return this.m_predictor;
    }

    public int getType() {
        return this.m_filterType;
    }

    public void setPredictor(Integer n) throws PDFFilterException {
        if (this.m_filterType != LZW_DECODE && this.m_filterType != FLATE_DECODE) {
            throw new PDFFilterException("No Predictor property for this filter");
        }
        this.m_predictor = n;
    }

    public String toPDF() {
        String string = null;
        if (this.m_filterType == ASCII_HEX_DECODE) {
            string = "/ASCIIHexDecode";
        } else if (this.m_filterType == ASCII_85_DECODE) {
            string = "/ASCI85Decode";
        } else if (this.m_filterType == LZW_DECODE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/LZWDecode");
            if (this.m_predictor != null) {
                stringBuffer.append(" /Predictor ");
                stringBuffer.append(this.m_predictor);
            }
            if (this.m_columns != null) {
                stringBuffer.append(" /Columns ");
                stringBuffer.append(this.m_columns);
            }
            if (this.m_colors != null) {
                stringBuffer.append(" /Colors ");
                stringBuffer.append(this.m_colors);
            }
            if (this.m_bitsPerComponent != null) {
                stringBuffer.append(" /BitsPerComponent ");
                stringBuffer.append(this.m_bitsPerComponent);
            }
            if (this.m_earlyChange != null) {
                stringBuffer.append(" /EarlyChange ");
                stringBuffer.append(this.m_earlyChange);
            }
            string = stringBuffer.toString();
        } else if (this.m_filterType == FLATE_DECODE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/FlateDecode");
            if (this.m_predictor != null) {
                stringBuffer.append(" /Predictor ");
                stringBuffer.append(this.m_predictor);
            }
            if (this.m_columns != null) {
                stringBuffer.append(" /Columns ");
                stringBuffer.append(this.m_columns);
            }
            if (this.m_colors != null) {
                stringBuffer.append(" /Colors ");
                stringBuffer.append(this.m_colors);
            }
            if (this.m_bitsPerComponent != null) {
                stringBuffer.append(" /BitsPerComponent ");
                stringBuffer.append(this.m_bitsPerComponent);
            }
            string = stringBuffer.toString();
        } else if (this.m_filterType == RUN_LENGTH_DECODE) {
            string = "/RunLengthDecode";
        } else if (this.m_filterType == CCITT_FAX_DECODE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/CCITTFaxDecode");
            if (this.m_k != null) {
                stringBuffer.append(" /K ");
                stringBuffer.append(this.m_k);
            }
            if (this.m_endOfLine != null) {
                stringBuffer.append(" /EndOfLine ");
                stringBuffer.append(this.m_endOfLine);
            }
            if (this.m_encodedByteAlign != null) {
                stringBuffer.append(" /EncodedByteAlign ");
                stringBuffer.append(this.m_encodedByteAlign);
            }
            if (this.m_columns != null) {
                stringBuffer.append(" /Columns ");
                stringBuffer.append(this.m_columns);
            }
            if (this.m_rows != null) {
                stringBuffer.append(" /Rows ");
                stringBuffer.append(this.m_rows);
            }
            if (this.m_endOfBlock != null) {
                stringBuffer.append(" /EndOfBlock ");
                stringBuffer.append(this.m_endOfBlock);
            }
            if (this.m_blackls1 != null) {
                stringBuffer.append(" /Blackls1 ");
                stringBuffer.append(this.m_blackls1);
            }
            if (this.m_damagedRowsBeforeError != null) {
                stringBuffer.append(" /DamagedRowsBeforeError ");
                stringBuffer.append(this.m_damagedRowsBeforeError);
            }
            string = stringBuffer.toString();
        } else if (this.m_filterType == DCT_DECODE) {
            string = "/DCTDecode";
        }
        return string;
    }
}

