/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFBinaryStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;
import org.apache.fop.pdf.PDFObject;

public class PDFXObject
extends PDFObject {
    FopImage fopimage;
    int Xnum;

    public PDFXObject(int n, int n2, FopImage fopImage) {
        super(n);
        this.Xnum = n2;
        if (fopImage == null) {
            MessageHandler.errorln("FISH");
        }
        this.fopimage = fopImage;
    }

    public int getXNumber() {
        return this.Xnum;
    }

    protected int output(PrintWriter printWriter) throws IOException {
        int n = 0;
        boolean bl = false;
        try {
            PDFBinaryStream pDFBinaryStream = new PDFBinaryStream();
            pDFBinaryStream.setData(this.fopimage.getBitmaps());
            pDFBinaryStream.encode(new PDFFilter(PDFFilter.FLATE_DECODE));
            pDFBinaryStream.encode(new PDFFilter(PDFFilter.ASCII_HEX_DECODE));
            String string = String.valueOf(this.number) + " " + this.generation + " obj\n";
            string = String.valueOf(string) + "<</Type /XObject\n";
            string = String.valueOf(string) + "/Subtype /Image\n";
            string = String.valueOf(string) + "/Name /Im" + this.Xnum + "\n";
            string = String.valueOf(string) + "/Width " + this.fopimage.getWidth() + "\n";
            string = String.valueOf(string) + "/Height " + this.fopimage.getHeight() + "\n";
            string = String.valueOf(string) + "/BitsPerComponent " + this.fopimage.getBitsPerPixel() + "\n";
            ColorSpace colorSpace = this.fopimage.getColorSpace();
            string = String.valueOf(string) + "/ColorSpace /" + colorSpace.getColorSpacePDFString() + "\n";
            if (this.fopimage.isTransparent()) {
                PDFColor pDFColor = this.fopimage.getTransparentColor();
                string = String.valueOf(string) + "/Mask [" + pDFColor.red255() + " " + pDFColor.red255() + " " + pDFColor.green255() + " " + pDFColor.green255() + " " + pDFColor.blue255() + " " + pDFColor.blue255() + "]\n";
            }
            string = String.valueOf(string) + pDFBinaryStream.getPDFDictionary();
            string = String.valueOf(string) + ">>\n";
            this.fopimage.close();
            printWriter.write(string);
            n += string.length();
            n += pDFBinaryStream.outputPDFStream(printWriter);
            string = "endobj\n";
            printWriter.write(string);
            n += string.length();
        }
        catch (FopImageException fopImageException) {
            MessageHandler.errorln("Error in XObject : " + fopImageException.getMessage());
        }
        catch (PDFFilterException pDFFilterException) {
            MessageHandler.errorln("Error in XObject : " + pDFFilterException.getMessage());
        }
        return n;
    }

    String toPDF() {
        return null;
    }
}

