/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.dom.svg.SVGArea;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.ForeignObjectArea;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.layout.LeaderArea;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.Page;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.pdf.SVGRenderer;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFRenderer
implements Renderer {
    protected PDFDocument pdfDoc;
    protected PDFResources pdfResources;
    protected IDReferences idReferences;
    PDFStream currentStream;
    PDFAnnotList currentAnnotList;
    PDFPage currentPage;
    protected String currentFontName;
    protected int currentFontSize;
    protected PDFPathPaint currentStroke = null;
    protected PDFPathPaint currentFill = null;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;
    private PDFColor currentColour = new PDFColor(0, 0, 0);

    public PDFRenderer() {
        this.pdfDoc = new PDFDocument();
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, PDFPathPaint pDFPathPaint) {
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re s\n" + "Q\nBT\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint, PDFPathPaint pDFPathPaint2) {
        this.currentStream.add("ET\nq\n" + pDFPathPaint2.getColorSpaceOut(true) + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re b\n" + "Q\nBT\n");
    }

    private void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        ColorType colorType = area.getBackgroundColor();
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addRect(n, n4, n2, -n3, new PDFColor(colorType), new PDFColor(colorType));
        }
        n -= area.borderWidthLeft;
        n4 += area.borderWidthTop;
        n2 = n2 + area.borderWidthLeft + area.borderWidthRight;
        n3 = n3 + area.borderWidthTop + area.borderWidthBottom;
        if (area.borderWidthTop != 0) {
            this.addLine(n, n4, n + n2, n4, area.borderWidthTop, new PDFColor(area.borderColorTop));
        }
        if (area.borderWidthLeft != 0) {
            this.addLine(n, n4, n, n4 - n3, area.borderWidthLeft, new PDFColor(area.borderColorLeft));
        }
        if (area.borderWidthRight != 0) {
            this.addLine(n + n2, n4, n + n2, n4 - n3, area.borderWidthRight, new PDFColor(area.borderColorRight));
        }
        if (area.borderWidthBottom != 0) {
            this.addLine(n, n4 - n3, n + n2, n4 - n3, area.borderWidthBottom, new PDFColor(area.borderColorBottom));
        }
    }

    public void render(AreaTree areaTree, PrintWriter printWriter) throws IOException, FOPException {
        MessageHandler.logln("rendering areas to PDF");
        this.idReferences = areaTree.getIDReferences();
        this.pdfResources = this.pdfDoc.getResources();
        this.pdfDoc.setIDReferences(this.idReferences);
        Enumeration enumeration = areaTree.getPages().elements();
        while (enumeration.hasMoreElements()) {
            this.renderPage((Page)enumeration.nextElement());
        }
        if (!this.idReferences.isEveryIdValid()) {
            MessageHandler.errorln("WARNING: The following id's were referenced but not found: " + this.idReferences.getInvalidIds() + "\n");
        }
        MessageHandler.logln("writing out PDF");
        this.pdfDoc.output(printWriter);
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 3) {
            this.currentYPosition = areaContainer.getYPosition() - 2 * areaContainer.getPaddingTop() - 2 * areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 2) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 1) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition += areaContainer.getPaddingLeft() + areaContainer.borderWidthLeft;
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (areaContainer.getPosition() != 1) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.doFrame(blockArea);
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        this.currentXPosition += foreignObjectArea.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (foreignObjectArea.getAlign()) {
            default: 
        }
        switch (foreignObjectArea.getVerticalAlign()) {
            default: 
        }
        this.currentStream.add("ET\n");
        this.currentStream.add("q\n");
        switch (foreignObjectArea.scalingMethod()) {
            default: 
        }
        switch (foreignObjectArea.getOverflow()) {
            default: 
        }
        foreignObjectArea.getObject().render(this);
        this.currentStream.add("Q\n");
        this.currentStream.add("BT\n");
        this.currentXPosition += foreignObjectArea.getEffectiveWidth();
        this.currentYPosition -= foreignObjectArea.getEffectiveHeight();
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage instanceof SVGImage) {
            try {
                SVGSVGElement sVGSVGElement = ((SVGImage)fopImage).getSVGDocument().getRootElement();
                this.currentStream.add("ET\nq\n" + (float)n3 / 1000.0f + " 0 0 " + (float)n4 / 1000.0f + " " + (float)n / 1000.0f + " " + (float)(n2 - n4) / 1000.0f + " cm\n");
                this.currentStream.add("Q\nBT\n");
            }
            catch (FopImageException fopImageException) {}
        } else {
            int n5 = this.pdfDoc.addImage(fopImage);
            this.currentStream.add("ET\nq\n" + (float)n3 / 1000.0f + " 0 0 " + (float)n4 / 1000.0f + " " + (float)n / 1000.0f + " " + (float)(n2 - n4) / 1000.0f + " cm\n" + "/Im" + n5 + " Do\nQ\nBT\n");
        }
    }

    public void renderInlineArea(InlineArea inlineArea) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = inlineArea.getFontState().getFontName();
        int n = inlineArea.getFontState().getFontSize();
        PDFColor pDFColor = new PDFColor(inlineArea.getRed(), inlineArea.getGreen(), inlineArea.getBlue());
        if (!string2.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string2;
            this.currentFontSize = n;
            stringBuffer = stringBuffer.append("/" + string2 + " " + n / 1000 + " Tf\n");
        }
        this.currentFill = pDFColor;
        stringBuffer = stringBuffer.append(this.currentFill.getColorSpaceOut(true));
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        stringBuffer = stringBuffer.append("1 0 0 1 " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " Tm (");
        if (inlineArea.getPageNumberID() != null) {
            string = this.idReferences.getPageNumber(inlineArea.getPageNumberID());
            if (string == null) {
                string = "";
            }
        } else {
            string = inlineArea.getText();
        }
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string.charAt(n5);
            if (c > '\u007f') {
                stringBuffer = stringBuffer.append("\\");
                stringBuffer = stringBuffer.append(Integer.toOctalString(c));
            } else {
                switch (c) {
                    case '(': {
                        stringBuffer = stringBuffer.append("\\(");
                        break;
                    }
                    case ')': {
                        stringBuffer = stringBuffer.append("\\)");
                        break;
                    }
                    case '\\': {
                        stringBuffer = stringBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuffer = stringBuffer.append(c);
                        break;
                    }
                }
            }
            ++n5;
        }
        stringBuffer = stringBuffer.append(") Tj\n");
        if (inlineArea.getUnderlined()) {
            this.addLine(n2, n3 - n / 10, n2 + inlineArea.getContentWidth(), n3 - n / 10, n / 14, pDFColor);
        }
        this.currentStream.add(stringBuffer.toString());
        this.currentXPosition += inlineArea.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getContentWidth();
        int n4 = leaderArea.getHeight();
        int n5 = leaderArea.getRuleThickness();
        int n6 = leaderArea.getRuleStyle();
        this.addLine(n, n2, n + n3, n2, n5, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
        this.currentXPosition += leaderArea.getContentWidth();
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            this.currentYPosition = n2 - lineArea.getPlacementOffset();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
        this.currentXPosition = n;
    }

    public void renderPage(Page page) {
        this.currentStream = this.pdfDoc.makeStream();
        AreaContainer areaContainer = page.getBody();
        AreaContainer areaContainer2 = page.getBefore();
        AreaContainer areaContainer3 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentStream.add("BT\n");
        this.renderAreaContainer(areaContainer);
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        this.currentStream.add("ET\n");
        this.currentPage = this.pdfDoc.makePage(this.pdfResources, this.currentStream, page.getWidth() / 1000, page.getHeight() / 1000, page);
        if (page.hasLinks()) {
            this.currentAnnotList = this.pdfDoc.makeAnnotList();
            this.currentPage.setAnnotList(this.currentAnnotList);
            Enumeration enumeration = page.getLinkSets().elements();
            while (enumeration.hasMoreElements()) {
                LinkSet linkSet = (LinkSet)enumeration.nextElement();
                linkSet.align();
                String string = linkSet.getDest();
                int n = linkSet.getLinkType();
                Enumeration enumeration2 = linkSet.getRects().elements();
                while (enumeration2.hasMoreElements()) {
                    LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration2.nextElement();
                    this.currentAnnotList.addLink(this.pdfDoc.makeLink(linkedRectangle.getRectangle(), string, n));
                }
            }
        } else {
            this.currentAnnotList = null;
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        SVGSVGElement sVGSVGElement = sVGArea.getSVGDocument().getRootElement();
        int n3 = (int)(sVGSVGElement.getWidth().getBaseVal().getValue() * 1000.0f);
        int n4 = (int)(sVGSVGElement.getHeight().getBaseVal().getValue() * 1000.0f);
        this.currentStream.add("q\n");
        this.currentStream.add(String.valueOf((float)n / 1000.0f) + " " + (float)n2 / 1000.0f + " m\n");
        this.currentStream.add(String.valueOf((float)(n + n3) / 1000.0f) + " " + (float)n2 / 1000.0f + " l\n");
        this.currentStream.add(String.valueOf((float)(n + n3) / 1000.0f) + " " + (float)(n2 - n4) / 1000.0f + " l\n");
        this.currentStream.add(String.valueOf((float)n / 1000.0f) + " " + (float)(n2 - n4) / 1000.0f + " l\n");
        this.currentStream.add("h\n");
        this.currentStream.add("W\n");
        this.currentStream.add("n\n");
        this.currentStream.add("1 0 0 -1 " + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " cm\n");
        SVGRenderer sVGRenderer = new SVGRenderer(sVGArea.getFontState(), this.pdfDoc, this.currentFontName, this.currentFontSize, this.currentXPosition, this.currentYPosition);
        sVGRenderer.renderSVG(sVGSVGElement, n, n2);
        this.currentStream.add(sVGRenderer.getString());
        this.currentStream.add("Q\n");
    }

    public void setProducer(String string) {
        this.pdfDoc.setProducer(string);
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
        FontSetup.addToResources(this.pdfDoc, fontInfo);
    }
}

