/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.dom.NodeImpl;
import org.apache.fop.dom.svg.GraphicElement;
import org.apache.fop.dom.svg.SVGAnimatedLengthImpl;
import org.apache.fop.dom.svg.SVGElementImpl;
import org.apache.fop.dom.svg.SVGGElementImpl;
import org.apache.fop.dom.svg.SVGImageElementImpl;
import org.apache.fop.dom.svg.SVGLengthImpl;
import org.apache.fop.dom.svg.SVGPathElementImpl;
import org.apache.fop.dom.svg.SVGPathSegImpl;
import org.apache.fop.dom.svg.SVGPolygonElementImpl;
import org.apache.fop.dom.svg.SVGPolylineElementImpl;
import org.apache.fop.dom.svg.SVGStopElementImpl;
import org.apache.fop.dom.svg.SVGTRefElementImpl;
import org.apache.fop.dom.svg.SVGTSpanElementImpl;
import org.apache.fop.dom.svg.SVGTextElementImpl;
import org.apache.fop.dom.svg.SVGTextPathElementImpl;
import org.apache.fop.dom.svg.SVGUseElementImpl;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.svg.PathPoint;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGLinearGradientElement;
import org.w3c.dom.svg.SVGList;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPatternElement;
import org.w3c.dom.svg.SVGRadialGradientElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.svg.SVGSwitchElement;
import org.w3c.dom.svg.SVGSymbolElement;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public class SVGRenderer {
    protected PDFDocument pdfDoc;
    protected FontState fontState;
    StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected int currentFontSize;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private PDFColor currentColour = new PDFColor(0, 0, 0);

    public SVGRenderer(FontState fontState, PDFDocument pDFDocument, String string, int n, int n2, int n3) {
        this.pdfDoc = pDFDocument;
        this.currentFontName = string;
        this.currentFontSize = n;
        this.currentYPosition = n3;
        this.currentXPosition = n2;
        this.fontState = fontState;
    }

    protected void addCircle(float f, float f2, float f3, DrawingInstruction drawingInstruction) {
        PDFNumber pDFNumber = new PDFNumber();
        String string = pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 - f3) + " m\n" + "" + pDFNumber.doubleOut(f + 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 - f3) + " " + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 - 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2) + " c\n" + "" + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 + 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f + 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 + f3) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 + f3) + " c\n" + "" + pDFNumber.doubleOut(f - 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 + f3) + " " + pDFNumber.doubleOut(f - f3) + " " + pDFNumber.doubleOut(f2 + 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f - f3) + " " + pDFNumber.doubleOut(f2) + " c\n" + "" + pDFNumber.doubleOut(f - f3) + " " + pDFNumber.doubleOut(f2 - 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f - 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 - f3) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 - f3) + " c\n";
        this.currentStream.write(string);
        this.doDrawing(drawingInstruction);
    }

    protected void addEllipse(float f, float f2, float f3, float f4, DrawingInstruction drawingInstruction) {
        PDFNumber pDFNumber = new PDFNumber();
        String string = pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 - f4) + " m\n" + "" + pDFNumber.doubleOut(f + 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 - f4) + " " + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 - 21.0f * f4 / 40.0f) + " " + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2) + " c\n" + "" + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 + 21.0f * f4 / 40.0f) + " " + pDFNumber.doubleOut(f + 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 + f4) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 + f4) + " c\n" + "" + pDFNumber.doubleOut(f - 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 + f4) + " " + pDFNumber.doubleOut(f - f3) + " " + pDFNumber.doubleOut(f2 + 21.0f * f4 / 40.0f) + " " + pDFNumber.doubleOut(f - f3) + " " + pDFNumber.doubleOut(f2) + " c\n" + "" + pDFNumber.doubleOut(f - f3) + " " + pDFNumber.doubleOut(f2 - 21.0f * f4 / 40.0f) + " " + pDFNumber.doubleOut(f - 21.0f * f3 / 40.0f) + " " + pDFNumber.doubleOut(f2 - f4) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 - f4) + " c\n";
        this.currentStream.write(string);
        this.doDrawing(drawingInstruction);
    }

    protected void addLine(float f, float f2, float f3, float f4, DrawingInstruction drawingInstruction) {
        PDFNumber pDFNumber = new PDFNumber();
        String string = pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " m " + pDFNumber.doubleOut(f3) + " " + pDFNumber.doubleOut(f4) + " l";
        if (drawingInstruction != null && drawingInstruction.fill) {
            this.currentStream.write(String.valueOf(string) + " f\n");
        }
        this.currentStream.write(String.valueOf(string) + " S\n");
    }

    protected void addPath(Vector vector, int n, int n2, DrawingInstruction drawingInstruction) {
        PDFNumber pDFNumber = new PDFNumber();
        SVGPathSegImpl sVGPathSegImpl = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SVGPathSegImpl sVGPathSegImpl2 = (SVGPathSegImpl)enumeration.nextElement();
            float[] fArray = sVGPathSegImpl2.getValues();
            switch (sVGPathSegImpl2.getPathSegType()) {
                case 2: {
                    sVGPathSegImpl = sVGPathSegImpl2;
                    f = fArray[0];
                    f2 = fArray[1];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2) + " m\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    f3 = f;
                    f4 = f2;
                    break;
                }
                case 3: {
                    if (sVGPathSegImpl == null) {
                        sVGPathSegImpl = sVGPathSegImpl2;
                        this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f += fArray[0])) + " " + pDFNumber.doubleOut(f2 += fArray[1]) + " m\n");
                    } else {
                        sVGPathSegImpl = sVGPathSegImpl2;
                        this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f += fArray[0])) + " " + pDFNumber.doubleOut(f2 += fArray[1]) + " l\n");
                    }
                    f3 = f;
                    f4 = f2;
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 4: {
                    f = fArray[0];
                    f2 = fArray[1];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2) + " l\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 5: {
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f += fArray[0])) + " " + pDFNumber.doubleOut(f2 += fArray[1]) + " l\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 14: {
                    f2 = fArray[0];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2) + " l\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 15: {
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2 += fArray[0]) + " l\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 12: {
                    f = fArray[0];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2) + " l\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 13: {
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f += fArray[0])) + " " + pDFNumber.doubleOut(f2) + " l\n");
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 6: {
                    f = fArray[4];
                    f2 = fArray[5];
                    f5 = fArray[2];
                    f6 = fArray[3];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(fArray[0])) + " " + pDFNumber.doubleOut(fArray[1]) + " " + pDFNumber.doubleOut(fArray[2]) + " " + pDFNumber.doubleOut(fArray[3]) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " c\n");
                    break;
                }
                case 7: {
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(fArray[0] + f)) + " " + pDFNumber.doubleOut(fArray[1] + f2) + " " + pDFNumber.doubleOut(fArray[2] + f) + " " + pDFNumber.doubleOut(fArray[3] + f2) + " " + pDFNumber.doubleOut(fArray[4] + f) + " " + pDFNumber.doubleOut(fArray[5] + f2) + " c\n");
                    f5 = fArray[2] + f;
                    f6 = fArray[3] + f2;
                    f += fArray[4];
                    f2 += fArray[5];
                    break;
                }
                case 16: {
                    if (f5 == 0.0f) {
                        f5 = f;
                    }
                    if (f6 == 0.0f) {
                        f6 = f2;
                    }
                    f5 = f + (f - f5);
                    f6 = f2 + (f2 - f6);
                    f = fArray[2];
                    f2 = fArray[3];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f5)) + " " + pDFNumber.doubleOut(f6) + " " + pDFNumber.doubleOut(fArray[0]) + " " + pDFNumber.doubleOut(fArray[1]) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " c\n");
                    f5 = fArray[0];
                    f6 = fArray[1];
                    break;
                }
                case 17: {
                    if (f5 == 0.0f) {
                        f5 = f;
                    }
                    if (f6 == 0.0f) {
                        f6 = f2;
                    }
                    f5 = f + (f - f5);
                    f6 = f2 + (f2 - f6);
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f5)) + " " + pDFNumber.doubleOut(f6) + " " + pDFNumber.doubleOut(fArray[0] + f) + " " + pDFNumber.doubleOut(fArray[1] + f2) + " " + pDFNumber.doubleOut(fArray[2] + f) + " " + pDFNumber.doubleOut(fArray[3] + f2) + " c\n");
                    f5 = fArray[0] + f;
                    f6 = fArray[1] + f2;
                    f += fArray[2];
                    f2 += fArray[3];
                    break;
                }
                case 8: {
                    if (f5 == 0.0f) {
                        f5 = f;
                    }
                    if (f6 == 0.0f) {
                        f6 = f2;
                    }
                    float f7 = f;
                    float f8 = f2;
                    f = fArray[2];
                    f2 = fArray[3];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(fArray[0])) + " " + pDFNumber.doubleOut(fArray[1]) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " y\n");
                    float[] fArray2 = this.calculateLastControl(f7, f8, f, f2, -f7 + fArray[0], -f8 + fArray[1]);
                    f5 = fArray2[0];
                    f6 = fArray2[1];
                    break;
                }
                case 9: {
                    if (f5 == 0.0f) {
                        f5 = f;
                    }
                    if (f6 == 0.0f) {
                        f6 = f2;
                    }
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(fArray[0] + f)) + " " + pDFNumber.doubleOut(fArray[1] + f2) + " " + pDFNumber.doubleOut(fArray[2] + f) + " " + pDFNumber.doubleOut(fArray[3] + f2) + " y\n");
                    float[] fArray2 = this.calculateLastControl(f, f2, f + fArray[2], f2 + fArray[3], fArray[0], fArray[1]);
                    f5 = fArray2[0];
                    f6 = fArray2[1];
                    f += fArray[2];
                    f2 += fArray[3];
                    break;
                }
                case 18: {
                    if (f5 == 0.0f) {
                        f5 = f;
                    }
                    if (f6 == 0.0f) {
                        f6 = f2;
                    }
                    float f7 = f;
                    float f8 = f2;
                    f5 = f + (f - f5);
                    f6 = f2 + (f2 - f6);
                    f = fArray[0];
                    f2 = fArray[1];
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f5)) + " " + pDFNumber.doubleOut(f6) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " y\n");
                    float[] fArray2 = this.calculateLastControl(f7, f8, f, f2, -f7 + f5, -f8 + f6);
                    f5 = fArray2[0];
                    f6 = fArray2[1];
                    break;
                }
                case 19: {
                    if (f5 == 0.0f) {
                        f5 = f;
                    }
                    if (f6 == 0.0f) {
                        f6 = f2;
                    }
                    f5 = f + (f - f5);
                    f6 = f2 + (f2 - f6);
                    this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f5)) + " " + pDFNumber.doubleOut(f6) + " " + pDFNumber.doubleOut(fArray[0] + f) + " " + pDFNumber.doubleOut(fArray[1] + f2) + " y\n");
                    float[] fArray2 = this.calculateLastControl(f, f2, f + fArray[0], f2 + fArray[1], -f + f5, -f2 + f6);
                    f5 = fArray2[0];
                    f6 = fArray2[1];
                    f += fArray[0];
                    f2 += fArray[1];
                    break;
                }
                case 1: {
                    this.currentStream.write("h\n");
                    sVGPathSegImpl = null;
                    f = f3;
                    f2 = f4;
                    break;
                }
            }
        }
        this.doDrawing(drawingInstruction);
    }

    protected void addPolyline(Vector vector, DrawingInstruction drawingInstruction, boolean bl) {
        PathPoint pathPoint;
        PDFNumber pDFNumber = new PDFNumber();
        float f = 0.0f;
        float f2 = 0.0f;
        Enumeration enumeration = vector.elements();
        if (enumeration.hasMoreElements()) {
            pathPoint = (PathPoint)enumeration.nextElement();
            f = pathPoint.x;
            f2 = pathPoint.y;
            this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2) + " m\n");
        }
        while (enumeration.hasMoreElements()) {
            pathPoint = (PathPoint)enumeration.nextElement();
            f = pathPoint.x;
            f2 = pathPoint.y;
            this.currentStream.write(String.valueOf(pDFNumber.doubleOut(f)) + " " + pDFNumber.doubleOut(f2) + " l\n");
        }
        if (bl) {
            this.currentStream.write("h\n");
        }
        this.doDrawing(drawingInstruction);
    }

    protected void addRect(float f, float f2, float f3, float f4, float f5, float f6, DrawingInstruction drawingInstruction) {
        PDFNumber pDFNumber = new PDFNumber();
        String string = "";
        if ((double)f5 == 0.0 && (double)f6 == 0.0) {
            string = pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " " + pDFNumber.doubleOut(f3) + " " + pDFNumber.doubleOut(f4) + " re\n";
        } else {
            if ((double)f6 == 0.0) {
                f6 = f5;
            }
            if (f5 > f3 / 2.0f) {
                f5 = f3 / 2.0f;
            }
            if (f6 > f4 / 2.0f) {
                f6 = f4 / 2.0f;
            }
            string = pDFNumber.doubleOut(f + f5) + " " + pDFNumber.doubleOut(f2) + " m\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f + f3 - f5) + " " + pDFNumber.doubleOut(f2) + " l\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f + f3 - 19.0f * f5 / 40.0f) + " " + pDFNumber.doubleOut(f2) + " " + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 + 19.0f * f6 / 40.0f) + " " + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 + f6) + " c\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 + f4 - f6) + " l\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f + f3) + " " + pDFNumber.doubleOut(f2 + f4 - 19.0f * f6 / 40.0f) + " " + pDFNumber.doubleOut(f + f3 - 19.0f * f5 / 40.0f) + " " + pDFNumber.doubleOut(f2 + f4) + " " + pDFNumber.doubleOut(f + f3 - f5) + " " + pDFNumber.doubleOut(f2 + f4) + " c\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f + f5) + " " + pDFNumber.doubleOut(f2 + f4) + " l\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f + 19.0f * f5 / 40.0f) + " " + pDFNumber.doubleOut(f2 + f4) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 + f4 - 19.0f * f6 / 40.0f) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 + f4 - f6) + " c\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 + f6) + " l\n";
            string = String.valueOf(string) + "" + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2 + 19.0f * f6 / 40.0f) + " " + pDFNumber.doubleOut(f + 19.0f * f5 / 40.0f) + " " + pDFNumber.doubleOut(f2) + " " + pDFNumber.doubleOut(f + f5) + " " + pDFNumber.doubleOut(f2) + " c\n";
        }
        this.currentStream.write(string);
        this.doDrawing(drawingInstruction);
    }

    protected float addSVGStr(FontState fontState, float f, String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '\u007f') {
                stringBuffer = stringBuffer.append("\\");
                stringBuffer = stringBuffer.append(Integer.toOctalString(c));
                f += (float)fontState.width(c) / 1000.0f;
                bl2 = true;
                bl3 = false;
            } else {
                switch (c) {
                    case '(': {
                        stringBuffer = stringBuffer.append("\\(");
                        f += (float)fontState.width(c) / 1000.0f;
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    case ')': {
                        stringBuffer = stringBuffer.append("\\)");
                        f += (float)fontState.width(c) / 1000.0f;
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    case '\\': {
                        stringBuffer = stringBuffer.append("\\\\");
                        f += (float)fontState.width(c) / 1000.0f;
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (bl) {
                            stringBuffer = stringBuffer.append(' ');
                            f += (float)fontState.width(32) / 1000.0f;
                            break;
                        }
                        if (!bl2 || bl3) break;
                        bl3 = true;
                        stringBuffer = stringBuffer.append(' ');
                        f += (float)fontState.width(32) / 1000.0f;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (!bl) break;
                        stringBuffer = stringBuffer.append(' ');
                        f += (float)fontState.width(32) / 1000.0f;
                        break;
                    }
                    default: {
                        bl3 = false;
                        stringBuffer = stringBuffer.append(c);
                        f += (float)fontState.width(c) / 1000.0f;
                        bl2 = true;
                        break;
                    }
                }
            }
            ++n;
        }
        this.currentStream.write(stringBuffer.toString());
        return f;
    }

    protected DrawingInstruction applyStyle(SVGElement sVGElement, SVGStylable sVGStylable) {
        PDFColor pDFColor;
        float f;
        float f2;
        float f3;
        Object object;
        Object object2;
        DrawingInstruction drawingInstruction = new DrawingInstruction();
        CSSValue cSSValue = sVGStylable.getPresentationAttribute("fill");
        if (cSSValue != null) {
            if (cSSValue.getValueType() == 1) {
                if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 25) {
                    object2 = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
                    object = object2.getRed();
                    f3 = object.getFloatValue((short)1);
                    object = object2.getGreen();
                    f2 = object.getFloatValue((short)1);
                    object = object2.getBlue();
                    f = object.getFloatValue((short)1);
                    this.currentColour = pDFColor = new PDFColor(f3, f2, f);
                    this.currentStream.write(pDFColor.getColorSpaceOut(true));
                    drawingInstruction.fill = true;
                } else if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 20) {
                    object2 = ((CSSPrimitiveValue)cSSValue).getCssText();
                    this.handleGradient((String)object2, drawingInstruction, true, sVGElement);
                } else if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19) {
                    object2 = ((CSSPrimitiveValue)cSSValue).getCssText();
                    if (((String)object2).equals("none")) {
                        drawingInstruction.fill = false;
                    } else if (((String)object2).equals("currentColor")) {
                        this.currentStream.write(this.currentColour.getColorSpaceOut(true));
                        drawingInstruction.fill = true;
                    }
                }
            }
        } else {
            object2 = new PDFColor(0, 0, 0);
            this.currentStream.write(((PDFColor)object2).getColorSpaceOut(true));
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("fill-rule")) != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19 && cSSValue.getCssText().equals("nonzero")) {
            drawingInstruction.nonzero = true;
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("stroke")) != null) {
            if (cSSValue.getValueType() == 1) {
                if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 25) {
                    object2 = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
                    object = object2.getRed();
                    f3 = object.getFloatValue((short)1);
                    object = object2.getGreen();
                    f2 = object.getFloatValue((short)1);
                    object = object2.getBlue();
                    f = object.getFloatValue((short)1);
                    pDFColor = new PDFColor(f3, f2, f);
                    this.currentStream.write(pDFColor.getColorSpaceOut(false));
                    drawingInstruction.stroke = true;
                } else if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 20) {
                    object2 = ((CSSPrimitiveValue)cSSValue).getCssText();
                    this.handleGradient((String)object2, drawingInstruction, false, sVGElement);
                } else if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19 && ((String)(object2 = ((CSSPrimitiveValue)cSSValue).getCssText())).equals("none")) {
                    drawingInstruction.stroke = false;
                }
            }
        } else {
            object2 = new PDFColor(0, 0, 0);
            this.currentStream.write(((PDFColor)object2).getColorSpaceOut(false));
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("stroke-linecap")) != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19) {
            object2 = cSSValue.getCssText();
            if (((String)object2).equals("butt")) {
                this.currentStream.write("0 J\n");
            } else if (((String)object2).equals("round")) {
                this.currentStream.write("1 J\n");
            } else if (((String)object2).equals("square")) {
                this.currentStream.write("2 J\n");
            }
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("stroke-linejoin")) != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19) {
            object2 = cSSValue.getCssText();
            if (((String)object2).equals("miter")) {
                this.currentStream.write("0 j\n");
            } else if (((String)object2).equals("round")) {
                this.currentStream.write("1 j\n");
            } else if (((String)object2).equals("bevel")) {
                this.currentStream.write("2 j\n");
            }
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("stroke-miterlimit")) != null && cSSValue.getValueType() == 1) {
            float f4 = ((CSSPrimitiveValue)cSSValue).getFloatValue((short)9);
            object = new PDFNumber();
            this.currentStream.write(String.valueOf(((PDFNumber)object).doubleOut(f4)) + " M\n");
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("stroke-width")) != null && cSSValue.getValueType() == 1) {
            float f5 = ((CSSPrimitiveValue)cSSValue).getFloatValue((short)9);
            object = new PDFNumber();
            this.currentStream.write(String.valueOf(((PDFNumber)object).doubleOut(f5)) + " w\n");
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("stroke-dasharray")) != null && cSSValue.getValueType() == 2) {
            this.currentStream.write("[ ");
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            int n = 0;
            while (n < cSSValueList.getLength()) {
                CSSValue cSSValue2 = cSSValueList.item(n);
                if (cSSValue2.getValueType() == 1) {
                    this.currentStream.write(String.valueOf(((CSSPrimitiveValue)cSSValue2).getFloatValue((short)1)) + " ");
                }
                ++n;
            }
            this.currentStream.write("] ");
            cSSValue = sVGStylable.getPresentationAttribute("stroke-dashoffset");
            if (cSSValue != null && cSSValue.getValueType() == 1) {
                this.currentStream.write(String.valueOf(((CSSPrimitiveValue)cSSValue).getFloatValue((short)1)) + " d\n");
            } else {
                this.currentStream.write("0 d\n");
            }
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("clip-path")) != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 20) {
            String string = ((CSSPrimitiveValue)cSSValue).getCssText();
            if (string.startsWith("url(")) {
                int n = string.indexOf("(");
                int n2 = string.indexOf(")");
                string = string.substring(n + 1, n2);
            }
            SVGElement sVGElement2 = null;
            sVGElement2 = this.locateDef(string, sVGElement);
            if (sVGElement2 != null) {
                MessageHandler.logln("clip path: " + sVGElement2);
            }
        }
        if ((cSSValue = sVGStylable.getPresentationAttribute("mask")) != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 20) {
            String string = ((CSSPrimitiveValue)cSSValue).getCssText();
            if (string.startsWith("url(")) {
                int n = string.indexOf("(");
                int n3 = string.indexOf(")");
                string = string.substring(n + 1, n3);
            }
            SVGElement sVGElement3 = null;
            sVGElement3 = this.locateDef(string, sVGElement);
            if (sVGElement3 != null) {
                MessageHandler.logln("mask: " + sVGElement3);
            }
        }
        return drawingInstruction;
    }

    protected void applyTransform(SVGAnimatedTransformList sVGAnimatedTransformList) {
        PDFNumber pDFNumber = new PDFNumber();
        SVGTransformList sVGTransformList = sVGAnimatedTransformList.getBaseVal();
        int n = 0;
        while (n < sVGTransformList.getNumberOfItems()) {
            SVGMatrix sVGMatrix = ((SVGTransform)sVGTransformList.getItem(n)).getMatrix();
            this.currentStream.write(String.valueOf(pDFNumber.doubleOut(sVGMatrix.getA())) + " " + pDFNumber.doubleOut(sVGMatrix.getB()) + " " + pDFNumber.doubleOut(sVGMatrix.getC()) + " " + pDFNumber.doubleOut(sVGMatrix.getD()) + " " + pDFNumber.doubleOut(sVGMatrix.getE()) + " " + pDFNumber.doubleOut(sVGMatrix.getF()) + " cm\n");
            ++n;
        }
    }

    protected float[] calculateLastControl(float f, float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = new float[2];
        f5 = -f5;
        f6 = -f6;
        float f7 = (float)Math.sqrt((f3 - f) * (f3 - f) + (f4 - f2) * (f4 - f2));
        float f8 = (f3 - f) / f7;
        float f9 = (f4 - f2) / f7;
        float f10 = f5;
        f5 = f5 * f8 + f6 * f9;
        f6 = -f10 * f9 + f6 * f8;
        f10 = f5 = -f5;
        f5 = f5 * f8 - f6 * f9;
        f6 = f10 * f9 + f6 * f8;
        fArray[0] = f3 - f5;
        fArray[1] = f4 - f6;
        return fArray;
    }

    protected void doDrawing(DrawingInstruction drawingInstruction) {
        if (drawingInstruction == null) {
            this.currentStream.write("S\n");
        } else if (drawingInstruction.fill) {
            if (drawingInstruction.stroke) {
                if (!drawingInstruction.nonzero) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (!drawingInstruction.nonzero) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public String getString() {
        return this.currentStream.toString();
    }

    protected void handleGradient(String string, DrawingInstruction drawingInstruction, boolean bl, SVGElement sVGElement) {
        String string2 = string;
        if (string2.startsWith("url(")) {
            int n = string2.indexOf("(");
            int n2 = string2.indexOf(")");
            String string3 = string2.substring(n + 1, n2);
            SVGElement sVGElement2 = null;
            sVGElement2 = this.locateDef(string3, sVGElement);
            if (sVGElement2 instanceof SVGLinearGradientElement) {
                SVGLinearGradientElement sVGLinearGradientElement = (SVGLinearGradientElement)sVGElement2;
                this.handleLinearGradient(sVGLinearGradientElement, drawingInstruction, bl, sVGElement);
            } else if (sVGElement2 instanceof SVGRadialGradientElement) {
                SVGRadialGradientElement sVGRadialGradientElement = (SVGRadialGradientElement)sVGElement2;
                this.handleRadialGradient(sVGRadialGradientElement, drawingInstruction, bl, sVGElement);
            } else if (sVGElement2 instanceof SVGPatternElement) {
                SVGPatternElement sVGPatternElement = (SVGPatternElement)sVGElement2;
                this.handlePattern(sVGPatternElement, drawingInstruction, bl, sVGElement);
            } else {
                MessageHandler.errorln("WARNING Invalid fill reference :" + sVGElement2 + ":" + string3);
            }
        }
    }

    protected void handleLinearGradient(SVGLinearGradientElement sVGLinearGradientElement, DrawingInstruction drawingInstruction, boolean bl, SVGElement sVGElement) {
        PDFPathPaint pDFPathPaint;
        Object object;
        Object object2;
        Object object3;
        Vector<Double> vector;
        short s = 0;
        short s2 = 0;
        NodeList nodeList = null;
        SVGAnimatedLength sVGAnimatedLength = sVGLinearGradientElement.getX1();
        SVGAnimatedLength sVGAnimatedLength2 = sVGLinearGradientElement.getX2();
        SVGAnimatedLength sVGAnimatedLength3 = sVGLinearGradientElement.getY1();
        SVGAnimatedLength sVGAnimatedLength4 = sVGLinearGradientElement.getY2();
        nodeList = sVGLinearGradientElement.getChildNodes();
        SVGLinearGradientElement sVGLinearGradientElement2 = (SVGLinearGradientElement)this.locateDef(sVGLinearGradientElement.getHref().getBaseVal(), (SVGElement)sVGLinearGradientElement);
        while (sVGLinearGradientElement2 != null) {
            if (sVGAnimatedLength == null) {
                sVGAnimatedLength = sVGLinearGradientElement2.getX1();
                s2 = sVGLinearGradientElement2.getGradientUnits().getBaseVal();
            }
            if (sVGAnimatedLength2 == null) {
                sVGAnimatedLength2 = sVGLinearGradientElement2.getX2();
            }
            if (sVGAnimatedLength3 == null) {
                sVGAnimatedLength3 = sVGLinearGradientElement2.getY1();
            }
            if (sVGAnimatedLength4 == null) {
                sVGAnimatedLength4 = sVGLinearGradientElement2.getY2();
            }
            if (nodeList.getLength() == 0) {
                nodeList = sVGLinearGradientElement2.getChildNodes();
            }
            sVGLinearGradientElement2 = (SVGLinearGradientElement)this.locateDef(sVGLinearGradientElement2.getHref().getBaseVal(), (SVGElement)sVGLinearGradientElement2);
        }
        if (sVGAnimatedLength == null) {
            vector = new SVGLengthImpl();
            vector.newValueSpecifiedUnits((short)2, 0.0f);
            sVGAnimatedLength = new SVGAnimatedLengthImpl((SVGLength)vector);
        }
        if (sVGAnimatedLength2 == null) {
            vector = new SVGLengthImpl();
            vector.newValueSpecifiedUnits((short)2, 1.0f);
            sVGAnimatedLength2 = new SVGAnimatedLengthImpl((SVGLength)vector);
        }
        if (sVGAnimatedLength3 == null) {
            vector = new SVGLengthImpl();
            vector.newValueSpecifiedUnits((short)2, 0.0f);
            sVGAnimatedLength3 = new SVGAnimatedLengthImpl((SVGLength)vector);
        }
        if (sVGAnimatedLength4 == null) {
            vector = new SVGLengthImpl();
            vector.newValueSpecifiedUnits((short)2, 0.0f);
            sVGAnimatedLength4 = new SVGAnimatedLengthImpl((SVGLength)vector);
        }
        vector = null;
        if (s2 == 0) {
            s2 = sVGLinearGradientElement.getGradientUnits().getBaseVal();
        }
        s = sVGLinearGradientElement.getSpreadMethod().getBaseVal();
        if (s2 == 1) {
            if (sVGElement instanceof SVGTransformable) {
                object3 = (SVGTransformable)sVGElement;
                double d = sVGAnimatedLength.getBaseVal().getValue();
                double d2 = -sVGAnimatedLength3.getBaseVal().getValue();
                double d3 = sVGAnimatedLength2.getBaseVal().getValue();
                double d4 = -sVGAnimatedLength4.getBaseVal().getValue();
                object2 = object3.getScreenCTM();
                double d5 = d;
                d = (double)object2.getA() * d + (double)object2.getB() * d2 + (double)object2.getE();
                d2 = (double)object2.getC() * d5 + (double)object2.getD() * d2 + (double)object2.getF();
                d5 = d3;
                d3 = (double)object2.getA() * d3 + (double)object2.getB() * d4 + (double)object2.getE();
                d4 = (double)object2.getC() * d5 + (double)object2.getD() * d4 + (double)object2.getF();
                vector = new Vector();
                if (s != 2 && s != 2) {
                    vector.addElement(new Double((double)((float)this.currentXPosition / 1000.0f) + d));
                    vector.addElement(new Double((double)((float)this.currentYPosition / 1000.0f) - d2));
                    vector.addElement(new Double((double)((float)this.currentXPosition / 1000.0f) + d3));
                    vector.addElement(new Double((double)((float)this.currentYPosition / 1000.0f) - d4));
                }
            }
        } else if (sVGElement instanceof GraphicElement && (object3 = ((GraphicElement)sVGElement).getBBox()) != null) {
            vector = new Vector<Double>();
            SVGLength sVGLength = sVGAnimatedLength.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s2 == 3) {
                vector.addElement(new Double((float)this.currentXPosition / 1000.0f + object3.getX() + sVGLength.getValue() * object3.getWidth()));
            } else {
                vector.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGLength.getValue()));
            }
            sVGLength = sVGAnimatedLength3.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s2 == 3) {
                vector.addElement(new Double((float)this.currentYPosition / 1000.0f - object3.getY() - sVGLength.getValue() * object3.getHeight()));
            } else {
                vector.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGLength.getValue()));
            }
            sVGLength = sVGAnimatedLength2.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s2 == 3) {
                vector.addElement(new Double((float)this.currentXPosition / 1000.0f + object3.getX() + sVGLength.getValue() * object3.getWidth()));
            } else {
                vector.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGLength.getValue()));
            }
            sVGLength = sVGAnimatedLength4.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s2 == 3) {
                vector.addElement(new Double((float)this.currentYPosition / 1000.0f - object3.getY() - sVGLength.getValue() * object3.getHeight()));
            } else {
                vector.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGLength.getValue()));
            }
        }
        if (vector == null) {
            vector = new Vector();
            vector.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGAnimatedLength.getBaseVal().getValue()));
            vector.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGAnimatedLength3.getBaseVal().getValue()));
            vector.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGAnimatedLength2.getBaseVal().getValue()));
            vector.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGAnimatedLength4.getBaseVal().getValue()));
        }
        object3 = new Vector();
        ((Vector)object3).addElement(new Boolean(true));
        ((Vector)object3).addElement(new Boolean(true));
        Vector<Double> vector2 = new Vector<Double>();
        vector2.addElement(new Double(0.0));
        vector2.addElement(new Double(1.0));
        Vector<Double> vector3 = new Vector<Double>();
        vector3.addElement(new Double(0.0));
        vector3.addElement(new Double(1.0));
        vector3.addElement(new Double(0.0));
        vector3.addElement(new Double(1.0));
        Vector<Double> vector4 = new Vector<Double>();
        vector4.addElement(new Double(0.0));
        vector4.addElement(new Double(1.0));
        Vector<PDFFunction> vector5 = new Vector<PDFFunction>();
        NodeList nodeList2 = nodeList;
        Vector<PDFPathPaint> vector6 = new Vector<PDFPathPaint>();
        float f = 0.0f;
        Vector vector7 = null;
        if (nodeList2.getLength() == 0) {
            if (bl) {
                drawingInstruction.fill = false;
            } else {
                drawingInstruction.stroke = false;
            }
            return;
        }
        if (nodeList2.getLength() == 1) {
            object2 = (SVGStopElementImpl)nodeList2.item(0);
            CSSValue cSSValue = ((SVGElementImpl)object2).getPresentationAttribute("stop-color");
            if (cSSValue == null) {
                cSSValue = ((SVGElementImpl)object2).getPresentationAttribute("color");
            }
            if (cSSValue == null) {
                MessageHandler.errorln("no stop-color or color in stop element");
                return;
            }
            PDFColor pDFColor = new PDFColor(0, 0, 0);
            if (cSSValue != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 25) {
                RGBColor rGBColor = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
                CSSPrimitiveValue cSSPrimitiveValue = rGBColor.getRed();
                float f2 = cSSPrimitiveValue.getFloatValue((short)1);
                cSSPrimitiveValue = rGBColor.getGreen();
                float f3 = cSSPrimitiveValue.getFloatValue((short)1);
                cSSPrimitiveValue = rGBColor.getBlue();
                float f4 = cSSPrimitiveValue.getFloatValue((short)1);
                pDFColor = new PDFColor(f2, f3, f4);
            }
            this.currentStream.write(pDFColor.getColorSpaceOut(bl));
            if (bl) {
                drawingInstruction.fill = true;
            } else {
                drawingInstruction.stroke = true;
            }
            return;
        }
        int n = 0;
        while (n < nodeList2.getLength()) {
            object2 = (SVGStopElementImpl)nodeList2.item(n);
            object = ((SVGElementImpl)object2).getPresentationAttribute("stop-color");
            if (object == null) {
                object = ((SVGElementImpl)object2).getPresentationAttribute("color");
            }
            if (object == null) {
                MessageHandler.errorln("no stop-color or color in stop element");
            } else {
                Object object4;
                pDFPathPaint = new PDFColor(0, 0, 0);
                if (object != null && object.getValueType() == 1 && ((CSSPrimitiveValue)object).getPrimitiveType() == 25) {
                    RGBColor rGBColor = ((CSSPrimitiveValue)object).getRGBColorValue();
                    object4 = rGBColor.getRed();
                    float f5 = object4.getFloatValue((short)1);
                    object4 = rGBColor.getGreen();
                    float f6 = object4.getFloatValue((short)1);
                    object4 = rGBColor.getBlue();
                    float f7 = object4.getFloatValue((short)1);
                    pDFPathPaint = new PDFColor(f5, f6, f7);
                    this.currentColour = pDFPathPaint;
                }
                float f8 = ((SVGStopElementImpl)object2).getOffset().getBaseVal();
                object4 = ((PDFColor)pDFPathPaint).getVector();
                if (vector7 != null) {
                    Vector vector8 = vector7;
                    Vector vector9 = object4;
                    PDFFunction pDFFunction = this.pdfDoc.makeFunction(2, vector2, null, vector8, vector9, 1.0);
                    vector5.addElement(pDFFunction);
                }
                f = f8;
                vector7 = object4;
                vector6.addElement(pDFPathPaint);
            }
            ++n;
        }
        object = new ColorSpace(ColorSpace.DEVICE_RGB);
        pDFPathPaint = this.pdfDoc.createGradient(false, (ColorSpace)object, vector6, null, vector);
        this.currentStream.write(((PDFPattern)pDFPathPaint).getColorSpaceOut(bl));
        if (bl) {
            drawingInstruction.fill = true;
        } else {
            drawingInstruction.stroke = true;
        }
    }

    protected void handlePattern(SVGPatternElement sVGPatternElement, DrawingInstruction drawingInstruction, boolean bl, SVGElement sVGElement) {
        Object object;
        short s = 0;
        Object var10_6 = null;
        SVGAnimatedLength sVGAnimatedLength = sVGPatternElement.getX();
        SVGAnimatedLength sVGAnimatedLength2 = sVGPatternElement.getY();
        SVGAnimatedLength sVGAnimatedLength3 = sVGPatternElement.getWidth();
        SVGAnimatedLength sVGAnimatedLength4 = sVGPatternElement.getHeight();
        NodeList nodeList = sVGPatternElement.getChildNodes();
        SVGPatternElement sVGPatternElement2 = (SVGPatternElement)this.locateDef(sVGPatternElement.getHref().getBaseVal(), (SVGElement)sVGPatternElement);
        while (sVGPatternElement2 != null) {
            if (sVGAnimatedLength == null) {
                sVGAnimatedLength = sVGPatternElement2.getX();
                s = sVGPatternElement2.getPatternUnits().getBaseVal();
            }
            if (sVGAnimatedLength2 == null) {
                sVGAnimatedLength2 = sVGPatternElement2.getY();
            }
            if (sVGAnimatedLength3 == null) {
                sVGAnimatedLength3 = sVGPatternElement2.getWidth();
            }
            if (sVGAnimatedLength4 == null) {
                sVGAnimatedLength4 = sVGPatternElement2.getHeight();
            }
            if (nodeList.getLength() == 0) {
                nodeList = sVGPatternElement2.getChildNodes();
            }
            sVGPatternElement2 = (SVGPatternElement)this.locateDef(sVGPatternElement2.getHref().getBaseVal(), (SVGElement)sVGPatternElement2);
        }
        if (sVGAnimatedLength == null) {
            object = new SVGLengthImpl();
            object.newValueSpecifiedUnits((short)2, 0.0f);
            sVGAnimatedLength = new SVGAnimatedLengthImpl((SVGLength)object);
        }
        if (sVGAnimatedLength2 == null) {
            object = new SVGLengthImpl();
            object.newValueSpecifiedUnits((short)2, 0.0f);
            sVGAnimatedLength2 = new SVGAnimatedLengthImpl((SVGLength)object);
        }
        if (sVGAnimatedLength3 == null) {
            object = new SVGLengthImpl();
            object.newValueSpecifiedUnits((short)2, 1.0f);
            sVGAnimatedLength3 = new SVGAnimatedLengthImpl((SVGLength)object);
        }
        if (sVGAnimatedLength4 == null) {
            object = new SVGLengthImpl();
            object.newValueSpecifiedUnits((short)2, 1.0f);
            sVGAnimatedLength4 = new SVGAnimatedLengthImpl((SVGLength)object);
        }
        object = this.currentStream;
        this.currentStream = new StringWriter();
        this.currentStream.write("q\n");
        this.currentStream.write("1 0 0 -1 0 " + sVGAnimatedLength4.getBaseVal().getValue() + " cm\n");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof SVGElement) {
                this.renderElement((SVGElement)node, 0, 0);
            }
            ++n;
        }
        this.currentStream.write("Q\n");
        double d = sVGAnimatedLength.getBaseVal().getValue() + (float)this.currentXPosition / 1000.0f;
        double d2 = -sVGAnimatedLength2.getBaseVal().getValue() + (float)this.currentYPosition / 1000.0f;
        if (sVGElement instanceof GraphicElement) {
            SVGRect sVGRect = ((GraphicElement)sVGElement).getBBox();
        }
        double d3 = sVGAnimatedLength3.getBaseVal().getValue();
        double d4 = sVGAnimatedLength4.getBaseVal().getValue();
        Vector<Double> vector = new Vector<Double>();
        vector.addElement(new Double(0.0));
        vector.addElement(new Double(0.0));
        vector.addElement(new Double(d3));
        vector.addElement(new Double(d4));
        Vector<Double> vector2 = new Vector<Double>();
        vector2.addElement(new Double(1.0));
        vector2.addElement(new Double(0.0));
        vector2.addElement(new Double(0.0));
        vector2.addElement(new Double(1.0));
        vector2.addElement(new Double(d));
        vector2.addElement(new Double(d2));
        PDFPattern pDFPattern = this.pdfDoc.makePattern(1, null, 1, 1, vector, d3, d4, vector2, null, this.currentStream.getBuffer());
        this.currentStream = object;
        this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
        if (bl) {
            drawingInstruction.fill = true;
        } else {
            drawingInstruction.stroke = true;
        }
    }

    protected void handleRadialGradient(SVGRadialGradientElement sVGRadialGradientElement, DrawingInstruction drawingInstruction, boolean bl, SVGElement sVGElement) {
        Object object;
        SVGTransformable sVGTransformable;
        Object object2;
        short s = sVGRadialGradientElement.getGradientUnits().getBaseVal();
        NodeList nodeList = null;
        SVGAnimatedLength sVGAnimatedLength = sVGRadialGradientElement.getCx();
        SVGAnimatedLength sVGAnimatedLength2 = sVGRadialGradientElement.getCy();
        SVGAnimatedLength sVGAnimatedLength3 = sVGRadialGradientElement.getR();
        SVGAnimatedLength sVGAnimatedLength4 = sVGRadialGradientElement.getFx();
        SVGAnimatedLength sVGAnimatedLength5 = sVGRadialGradientElement.getFy();
        nodeList = sVGRadialGradientElement.getChildNodes();
        SVGRadialGradientElement sVGRadialGradientElement2 = (SVGRadialGradientElement)this.locateDef(sVGRadialGradientElement.getHref().getBaseVal(), (SVGElement)sVGRadialGradientElement);
        while (sVGRadialGradientElement2 != null) {
            if (sVGAnimatedLength == null) {
                sVGAnimatedLength = sVGRadialGradientElement2.getCx();
                s = sVGRadialGradientElement2.getGradientUnits().getBaseVal();
            }
            if (sVGAnimatedLength2 == null) {
                sVGAnimatedLength2 = sVGRadialGradientElement2.getCy();
            }
            if (sVGAnimatedLength3 == null) {
                sVGAnimatedLength3 = sVGRadialGradientElement2.getR();
            }
            if (sVGAnimatedLength4 == null) {
                sVGAnimatedLength4 = sVGRadialGradientElement2.getFx();
            }
            if (sVGAnimatedLength5 == null) {
                sVGAnimatedLength5 = sVGRadialGradientElement2.getFy();
            }
            if (nodeList.getLength() == 0) {
                nodeList = sVGRadialGradientElement2.getChildNodes();
            }
            sVGRadialGradientElement2 = (SVGRadialGradientElement)this.locateDef(sVGRadialGradientElement2.getHref().getBaseVal(), (SVGElement)sVGRadialGradientElement2);
        }
        if (sVGAnimatedLength == null) {
            object2 = new SVGLengthImpl();
            object2.newValueSpecifiedUnits((short)2, 0.5f);
            sVGAnimatedLength = new SVGAnimatedLengthImpl((SVGLength)object2);
        }
        if (sVGAnimatedLength2 == null) {
            object2 = new SVGLengthImpl();
            object2.newValueSpecifiedUnits((short)2, 0.5f);
            sVGAnimatedLength2 = new SVGAnimatedLengthImpl((SVGLength)object2);
        }
        if (sVGAnimatedLength3 == null) {
            object2 = new SVGLengthImpl();
            object2.newValueSpecifiedUnits((short)2, 1.0f);
            sVGAnimatedLength3 = new SVGAnimatedLengthImpl((SVGLength)object2);
        }
        if (sVGAnimatedLength4 == null) {
            object2 = new SVGLengthImpl();
            object2.newValueSpecifiedUnits((short)2, 0.5f);
            sVGAnimatedLength4 = new SVGAnimatedLengthImpl((SVGLength)object2);
        }
        if (sVGAnimatedLength5 == null) {
            object2 = new SVGLengthImpl();
            object2.newValueSpecifiedUnits((short)2, 0.5f);
            sVGAnimatedLength5 = new SVGAnimatedLengthImpl((SVGLength)object2);
        }
        object2 = new ColorSpace(ColorSpace.DEVICE_RGB);
        NodeList nodeList2 = nodeList;
        if (nodeList2.getLength() == 0) {
            if (bl) {
                drawingInstruction.fill = false;
            } else {
                drawingInstruction.stroke = false;
            }
            return;
        }
        if (nodeList2.getLength() == 1) {
            SVGStopElementImpl sVGStopElementImpl = (SVGStopElementImpl)nodeList2.item(0);
            CSSValue cSSValue = sVGStopElementImpl.getPresentationAttribute("stop-color");
            if (cSSValue == null) {
                cSSValue = sVGStopElementImpl.getPresentationAttribute("color");
            }
            if (cSSValue == null) {
                MessageHandler.errorln("no stop-color or color in stop element");
                return;
            }
            PDFColor pDFColor = new PDFColor(0, 0, 0);
            if (cSSValue != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 25) {
                RGBColor rGBColor = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
                CSSPrimitiveValue cSSPrimitiveValue = rGBColor.getRed();
                float f = cSSPrimitiveValue.getFloatValue((short)1);
                cSSPrimitiveValue = rGBColor.getGreen();
                float f2 = cSSPrimitiveValue.getFloatValue((short)1);
                cSSPrimitiveValue = rGBColor.getBlue();
                float f3 = cSSPrimitiveValue.getFloatValue((short)1);
                pDFColor = new PDFColor(f, f2, f3);
            }
            this.currentStream.write(pDFColor.getColorSpaceOut(bl));
            if (bl) {
                drawingInstruction.fill = true;
            } else {
                drawingInstruction.stroke = true;
            }
            return;
        }
        Object var16_18 = null;
        Vector<PDFColor> vector = new Vector<PDFColor>();
        Vector<Double> vector2 = null;
        Vector vector3 = new Vector();
        if (s == 1) {
            if (sVGElement instanceof SVGTransformable) {
                sVGTransformable = (SVGTransformable)sVGElement;
                double d = sVGAnimatedLength.getBaseVal().getValue();
                double d2 = -sVGAnimatedLength2.getBaseVal().getValue();
                double d3 = sVGAnimatedLength4.getBaseVal().getValue();
                double d4 = -sVGAnimatedLength5.getBaseVal().getValue();
                SVGMatrix sVGMatrix = sVGTransformable.getScreenCTM();
                double d5 = d;
                d = (double)sVGMatrix.getA() * d + (double)sVGMatrix.getB() * d2 + (double)sVGMatrix.getE();
                d2 = (double)sVGMatrix.getC() * d5 + (double)sVGMatrix.getD() * d2 + (double)sVGMatrix.getF();
                d5 = d3;
                d3 = (double)sVGMatrix.getA() * d3 + (double)sVGMatrix.getB() * d4 + (double)sVGMatrix.getE();
                d4 = (double)sVGMatrix.getC() * d5 + (double)sVGMatrix.getD() * d4 + (double)sVGMatrix.getF();
                vector2 = new Vector();
                vector2.addElement(new Double((double)((float)this.currentXPosition / 1000.0f) + d));
                vector2.addElement(new Double((double)((float)this.currentYPosition / 1000.0f) - d2 + (double)((sVGMatrix.getC() - sVGMatrix.getD()) * 2.0f * sVGAnimatedLength3.getBaseVal().getValue())));
                vector2.addElement(new Double(0.0));
                vector2.addElement(new Double((double)((float)this.currentXPosition / 1000.0f) + d3));
                vector2.addElement(new Double((double)((float)this.currentYPosition / 1000.0f) - d4 + (double)((sVGMatrix.getC() - sVGMatrix.getD()) * 2.0f * sVGAnimatedLength3.getBaseVal().getValue())));
                vector2.addElement(new Double(sVGAnimatedLength3.getBaseVal().getValue()));
            }
        } else if (s == 3 && sVGElement instanceof GraphicElement && (sVGTransformable = ((GraphicElement)sVGElement).getBBox()) != null) {
            vector2 = new Vector();
            SVGLength sVGLength = sVGAnimatedLength.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s == 3) {
                vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGTransformable.getX() + sVGLength.getValue() * sVGTransformable.getWidth()));
            } else {
                vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGLength.getValue()));
            }
            sVGLength = sVGAnimatedLength2.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s == 3) {
                vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGTransformable.getY() - sVGLength.getValue() * sVGTransformable.getHeight()));
            } else {
                vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGLength.getValue()));
            }
            vector2.addElement(new Double(0.0));
            sVGLength = sVGAnimatedLength4.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s == 3) {
                vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGTransformable.getX() + sVGLength.getValue() * sVGTransformable.getWidth()));
            } else {
                vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGLength.getValue()));
            }
            sVGLength = sVGAnimatedLength5.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s == 3) {
                vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGTransformable.getY() - sVGLength.getValue() * sVGTransformable.getHeight()));
            } else {
                vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGLength.getValue()));
            }
            sVGLength = sVGAnimatedLength3.getBaseVal();
            if (sVGLength.getUnitType() == 2 || s == 3) {
                vector2.addElement(new Double(sVGLength.getValue() * sVGTransformable.getHeight()));
            } else {
                vector2.addElement(new Double(sVGLength.getValue()));
            }
        }
        if (vector2 == null) {
            SVGRect sVGRect;
            sVGTransformable = ((GraphicElement)sVGElement).getNearestViewportElement();
            if (sVGElement instanceof GraphicElement && (sVGRect = ((GraphicElement)sVGElement).getBBox()) != null) {
                vector2 = new Vector();
                object = sVGAnimatedLength.getBaseVal();
                if (object.getUnitType() == 2 || s == 3) {
                    vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGRect.getX() + object.getValue() * sVGRect.getWidth()));
                } else {
                    vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + object.getValue()));
                }
                object = sVGAnimatedLength2.getBaseVal();
                if (object.getUnitType() == 2 || s == 3) {
                    vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGRect.getY() - object.getValue() * sVGRect.getHeight()));
                } else {
                    vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - object.getValue()));
                }
                vector2.addElement(new Double(0.0));
                object = sVGAnimatedLength4.getBaseVal();
                if (object.getUnitType() == 2 || s == 3) {
                    vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGRect.getX() + object.getValue() * sVGRect.getWidth()));
                } else {
                    vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + object.getValue()));
                }
                object = sVGAnimatedLength5.getBaseVal();
                if (object.getUnitType() == 2 || s == 3) {
                    vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGRect.getY() - object.getValue() * sVGRect.getHeight()));
                } else {
                    vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - object.getValue()));
                }
                object = sVGAnimatedLength3.getBaseVal();
                if (object.getUnitType() == 2 || s == 3) {
                    vector2.addElement(new Double(object.getValue() * sVGRect.getHeight()));
                } else {
                    vector2.addElement(new Double(object.getValue()));
                }
            }
        }
        if (vector2 == null) {
            vector2 = new Vector<Double>();
            vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGAnimatedLength.getBaseVal().getValue()));
            vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGAnimatedLength2.getBaseVal().getValue()));
            vector2.addElement(new Double(0.0));
            vector2.addElement(new Double((float)this.currentXPosition / 1000.0f + sVGAnimatedLength4.getBaseVal().getValue()));
            vector2.addElement(new Double((float)this.currentYPosition / 1000.0f - sVGAnimatedLength5.getBaseVal().getValue()));
            vector2.addElement(new Double(sVGAnimatedLength3.getBaseVal().getValue()));
        }
        float f = 0.0f;
        int n = 0;
        while (n < nodeList2.getLength()) {
            SVGStopElementImpl sVGStopElementImpl = (SVGStopElementImpl)nodeList2.item(n);
            object = sVGStopElementImpl.getPresentationAttribute("stop-color");
            if (object == null) {
                object = sVGStopElementImpl.getPresentationAttribute("color");
            }
            if (object == null) {
                MessageHandler.errorln("no stop-color or color in stop element");
            } else {
                float f4;
                PDFColor pDFColor = new PDFColor(0, 0, 0);
                if (object != null && object.getValueType() == 1 && ((CSSPrimitiveValue)object).getPrimitiveType() == 25) {
                    RGBColor rGBColor = ((CSSPrimitiveValue)object).getRGBColorValue();
                    CSSPrimitiveValue cSSPrimitiveValue = rGBColor.getRed();
                    float f5 = cSSPrimitiveValue.getFloatValue((short)1);
                    cSSPrimitiveValue = rGBColor.getGreen();
                    float f6 = cSSPrimitiveValue.getFloatValue((short)1);
                    cSSPrimitiveValue = rGBColor.getBlue();
                    float f7 = cSSPrimitiveValue.getFloatValue((short)1);
                    pDFColor = new PDFColor(f5, f6, f7);
                }
                f = f4 = sVGStopElementImpl.getOffset().getBaseVal();
                vector.addElement(pDFColor);
            }
            ++n;
        }
        object = this.pdfDoc.createGradient(true, (ColorSpace)object2, vector, vector3, vector2);
        this.currentStream.write(((PDFPattern)object).getColorSpaceOut(bl));
        if (bl) {
            drawingInstruction.fill = true;
        } else {
            drawingInstruction.stroke = true;
        }
    }

    protected void handleSwitchElement(int n, int n2, SVGSwitchElement sVGSwitchElement) {
        SVGList sVGList = sVGSwitchElement.getRequiredExtensions();
        SVGList sVGList2 = sVGSwitchElement.getRequiredFeatures();
        SVGList sVGList3 = sVGSwitchElement.getSystemLanguage();
        NodeList nodeList = sVGSwitchElement.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            block20: {
                Node node;
                block23: {
                    int n4;
                    Object object;
                    GraphicElement graphicElement;
                    block22: {
                        SVGList sVGList4;
                        block21: {
                            node = nodeList.item(n3);
                            if (!(node instanceof GraphicElement)) break block20;
                            graphicElement = (GraphicElement)node;
                            SVGList sVGList5 = graphicElement.getRequiredExtensions();
                            if (sVGList5 == null) break block21;
                            if (sVGList5.getNumberOfItems() != 0 || sVGList == null || sVGList.getNumberOfItems() == 0) {
                                int n5 = 0;
                                while (n5 < sVGList5.getNumberOfItems()) {
                                    object = (String)sVGList5.getItem(n5);
                                    if (sVGList != null) {
                                        ++n5;
                                        continue;
                                    }
                                    break block20;
                                }
                            }
                            break block20;
                        }
                        if ((sVGList4 = graphicElement.getRequiredFeatures()) == null) break block22;
                        if (sVGList4.getNumberOfItems() == 0 && sVGList2 != null && sVGList2.getNumberOfItems() != 0) break block20;
                        int n6 = 0;
                        while (n6 < sVGList4.getNumberOfItems()) {
                            String string = (String)sVGList4.getItem(n6);
                            if (sVGList2 == null) {
                                if (!string.equals("org.w3c.svg.static") && !string.equals("org.w3c.dom.svg.all")) {
                                    break block20;
                                }
                            } else {
                                boolean bl = false;
                                n4 = 0;
                                while (n4 < sVGList2.getNumberOfItems()) {
                                    if (sVGList2.getItem(n4).equals(string)) {
                                        bl = true;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (!bl) break block20;
                            }
                            ++n6;
                        }
                    }
                    if ((object = graphicElement.getSystemLanguage()) == null) break block23;
                    if (object.getNumberOfItems() == 0 && sVGList3 != null && sVGList3.getNumberOfItems() != 0) break block20;
                    int n7 = 0;
                    while (n7 < object.getNumberOfItems()) {
                        String string = (String)object.getItem(n7);
                        if (sVGList3 == null) {
                            if (!string.equals("en")) {
                                break block20;
                            }
                        } else {
                            n4 = 0;
                            int n8 = 0;
                            while (n8 < sVGList3.getNumberOfItems()) {
                                if (sVGList3.getItem(n8).equals(string)) {
                                    n4 = 1;
                                    break;
                                }
                                ++n8;
                            }
                            if (n4 == 0) break block20;
                        }
                        ++n7;
                    }
                }
                this.renderElement((SVGElement)node, n, n2);
                break;
            }
            ++n3;
        }
    }

    protected SVGElement locateDef(String string, SVGElement sVGElement) {
        block5: {
            int n;
            block6: {
                n = (string = string.trim()).indexOf("#");
                if (n != 0) break block6;
                Document document = sVGElement.getOwnerDocument();
                Element element = document.getElementById(string.substring(1, string.length()));
                if (element instanceof SVGElement) {
                    return (SVGElement)element;
                }
                break block5;
            }
            if (n == -1) break block5;
            String string2 = string.substring(0, n);
            if (string2.indexOf(":") == -1) {
                string2 = "file:" + string2;
            }
            try {
                SVGDocument sVGDocument;
                Element element;
                FopImage fopImage = FopImageFactory.Make(string2);
                if (fopImage instanceof SVGImage && (element = (sVGDocument = ((SVGImage)fopImage).getSVGDocument()).getElementById(string.substring(n + 1, string.length()))) instanceof SVGElement) {
                    return (SVGElement)element;
                }
            }
            catch (Exception exception) {
                MessageHandler.errorln(exception.toString());
            }
        }
        return null;
    }

    public void renderElement(SVGElement sVGElement, int n, int n2) {
        Object object;
        Object object2;
        int n3 = n;
        int n4 = n2;
        DrawingInstruction drawingInstruction = null;
        this.currentStream.write("q\n");
        if (sVGElement instanceof SVGTransformable && (object2 = (object = (SVGTransformable)sVGElement).getTransform()) != null) {
            this.applyTransform((SVGAnimatedTransformList)object2);
        }
        if (sVGElement instanceof SVGStylable) {
            drawingInstruction = this.applyStyle(sVGElement, (SVGStylable)sVGElement);
        }
        if (sVGElement instanceof SVGRectElement) {
            object = (SVGRectElement)sVGElement;
            float f = object.getX().getBaseVal().getValue();
            float f2 = object.getY().getBaseVal().getValue();
            float f3 = object.getRx().getBaseVal().getValue();
            float f4 = object.getRy().getBaseVal().getValue();
            float f5 = object.getWidth().getBaseVal().getValue();
            float f6 = object.getHeight().getBaseVal().getValue();
            this.addRect(f, f2, f5, f6, f3, f4, drawingInstruction);
        } else if (sVGElement instanceof SVGLineElement) {
            object = (SVGLineElement)sVGElement;
            float f = object.getX1().getBaseVal().getValue();
            float f7 = object.getY1().getBaseVal().getValue();
            float f8 = object.getX2().getBaseVal().getValue();
            float f9 = object.getY2().getBaseVal().getValue();
            this.addLine(f, f7, f8, f9, drawingInstruction);
        } else if (sVGElement instanceof SVGTextElementImpl) {
            this.currentStream.write("BT\n");
            this.renderText((SVGTextElementImpl)sVGElement, 0.0f, 0.0f, drawingInstruction);
            this.currentStream.write("ET\n");
        } else if (sVGElement instanceof SVGCircleElement) {
            object = (SVGCircleElement)sVGElement;
            float f = object.getCx().getBaseVal().getValue();
            float f10 = object.getCy().getBaseVal().getValue();
            float f11 = object.getR().getBaseVal().getValue();
            this.addCircle(f, f10, f11, drawingInstruction);
        } else if (sVGElement instanceof SVGEllipseElement) {
            object = (SVGEllipseElement)sVGElement;
            float f = object.getCx().getBaseVal().getValue();
            float f12 = object.getCy().getBaseVal().getValue();
            float f13 = object.getRx().getBaseVal().getValue();
            float f14 = object.getRy().getBaseVal().getValue();
            this.addEllipse(f, f12, f13, f14, drawingInstruction);
        } else if (sVGElement instanceof SVGPathElementImpl) {
            this.addPath(((SVGPathElementImpl)sVGElement).pathElements, n, n2, drawingInstruction);
        } else if (sVGElement instanceof SVGPolylineElementImpl) {
            this.addPolyline(((SVGPolylineElementImpl)sVGElement).points, drawingInstruction, false);
        } else if (sVGElement instanceof SVGPolygonElementImpl) {
            this.addPolyline(((SVGPolygonElementImpl)sVGElement).points, drawingInstruction, true);
        } else if (sVGElement instanceof SVGGElementImpl) {
            this.renderGArea((SVGGElementImpl)sVGElement, n3, n4);
        } else if (sVGElement instanceof SVGUseElementImpl) {
            object = (SVGUseElementImpl)sVGElement;
            object2 = ((SVGUseElementImpl)object).link;
            SVGElement sVGElement2 = null;
            sVGElement2 = this.locateDef((String)object2, (SVGElement)object);
            if (sVGElement2 != null) {
                if (sVGElement2 instanceof SVGSymbolElement) {
                    this.currentStream.write("q\n");
                    SVGSymbolElement sVGSymbolElement = (SVGSymbolElement)sVGElement2;
                    SVGRect sVGRect = sVGSymbolElement.getViewBox().getBaseVal();
                    float f = ((SVGUseElementImpl)object).getX().getBaseVal().getValue();
                    float f15 = ((SVGUseElementImpl)object).getY().getBaseVal().getValue();
                    float f16 = ((SVGUseElementImpl)object).getWidth().getBaseVal().getValue();
                    float f17 = ((SVGUseElementImpl)object).getHeight().getBaseVal().getValue();
                    float f18 = f16 / sVGRect.getWidth();
                    float f19 = f17 / sVGRect.getHeight();
                    this.currentStream.write(String.valueOf(f) + " " + f15 + " m\n");
                    this.currentStream.write(String.valueOf(f + f16) + " " + f15 + " l\n");
                    this.currentStream.write(String.valueOf(f + f16) + " " + (f15 + f17) + " l\n");
                    this.currentStream.write(String.valueOf(f) + " " + (f15 + f17) + " l\n");
                    this.currentStream.write("h\n");
                    this.currentStream.write("W\n");
                    this.currentStream.write("n\n");
                    this.currentStream.write(String.valueOf(f18) + " 0 0 " + f19 + " " + f + " " + f15 + " cm\n");
                    this.renderSymbol(sVGSymbolElement, n, n2);
                    this.currentStream.write("Q\n");
                } else {
                    this.renderElement(sVGElement2, n, n2);
                }
            } else {
                MessageHandler.logln("Use Element: " + (String)object2 + " not found");
            }
        } else if (sVGElement instanceof SVGImageElementImpl) {
            object = (SVGImageElementImpl)sVGElement;
            this.renderImage(((SVGImageElementImpl)object).link, ((SVGImageElementImpl)object).x, ((SVGImageElementImpl)object).y, ((SVGImageElementImpl)object).width, ((SVGImageElementImpl)object).height);
        } else if (sVGElement instanceof SVGSVGElement) {
            this.currentStream.write("q\n");
            object = (SVGSVGElement)sVGElement;
            float f = 0.0f;
            if (object.getX() != null) {
                f = object.getX().getBaseVal().getValue();
            }
            float f20 = 0.0f;
            if (object.getY() != null) {
                f20 = object.getY().getBaseVal().getValue();
            }
            this.currentStream.write("1 0 0 1 " + f + " " + f20 + " cm\n");
            this.renderSVG((SVGSVGElement)object, (int)((float)n3 + 1000.0f * f), (int)((float)n4 + 1000.0f * f20));
            this.currentStream.write("Q\n");
        } else if (sVGElement instanceof SVGAElement) {
            object = (SVGAElement)sVGElement;
            object2 = object.getChildNodes();
            int n5 = 0;
            while (n5 < object2.getLength()) {
                Node node = object2.item(n5);
                if (node instanceof SVGElement) {
                    if (node instanceof GraphicElement) {
                        SVGRect sVGRect = ((GraphicElement)node).getBBox();
                    }
                    this.renderElement((SVGElement)node, n, n2);
                }
                ++n5;
            }
        } else if (sVGElement instanceof SVGSwitchElement) {
            this.handleSwitchElement(n, n2, (SVGSwitchElement)sVGElement);
        }
        this.currentStream.write("Q\n");
    }

    public void renderGArea(SVGGElement sVGGElement, int n, int n2) {
        NodeList nodeList = sVGGElement.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node = nodeList.item(n3);
            if (node instanceof SVGElement) {
                this.renderElement((SVGElement)node, n, n2);
            }
            ++n3;
        }
    }

    public void renderImage(String string, float f, float f2, float f3, float f4) {
        try {
            if (string.indexOf(":") == -1) {
                string = "file:" + string;
            }
            FopImage fopImage = FopImageFactory.Make(string);
            PDFNumber pDFNumber = new PDFNumber();
            if (fopImage instanceof SVGImage) {
                SVGSVGElement sVGSVGElement = ((SVGImage)fopImage).getSVGDocument().getRootElement();
                this.currentStream.write("q\n" + pDFNumber.doubleOut(f3 / sVGSVGElement.getWidth().getBaseVal().getValue()) + " 0 0 " + pDFNumber.doubleOut(f4 / sVGSVGElement.getHeight().getBaseVal().getValue()) + " 0 0 cm\n");
                this.renderSVG(sVGSVGElement, (int)f * 1000, (int)f2 * 1000);
                this.currentStream.write("Q\n");
            } else if (fopImage != null) {
                int n = this.pdfDoc.addImage(fopImage);
                this.currentStream.write("q\n1 0 0 -1 0 " + pDFNumber.doubleOut(2.0f * f2 + f4) + " cm\n" + pDFNumber.doubleOut(f3) + " 0 0 " + pDFNumber.doubleOut(f4) + " " + pDFNumber.doubleOut(f) + " " + pDFNumber.doubleOut(f2) + " cm\n" + "/Im" + n + " Do\nQ\n");
            }
        }
        catch (Exception exception) {
            MessageHandler.errorln("could not add image to SVG: " + string);
        }
    }

    protected void renderSVG(SVGSVGElement sVGSVGElement, int n, int n2) {
        NodeList nodeList = sVGSVGElement.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node = nodeList.item(n3);
            if (node instanceof SVGElement) {
                this.renderElement((SVGElement)node, n, n2);
            }
            ++n3;
        }
    }

    protected void renderSymbol(SVGSymbolElement sVGSymbolElement, int n, int n2) {
        NodeList nodeList = sVGSymbolElement.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node = nodeList.item(n3);
            if (node instanceof SVGElement) {
                this.renderElement((SVGElement)node, n, n2);
            }
            ++n3;
        }
    }

    public void renderText(SVGTextElementImpl sVGTextElementImpl, float f, float f2, DrawingInstruction drawingInstruction) {
        SVGTextRenderer sVGTextRenderer = new SVGTextRenderer(this.fontState, sVGTextElementImpl, f, f2);
        if (drawingInstruction.fill) {
            if (drawingInstruction.stroke) {
                this.currentStream.write("2 Tr\n");
            } else {
                this.currentStream.write("0 Tr\n");
            }
        } else if (drawingInstruction.stroke) {
            this.currentStream.write("1 Tr\n");
        }
        sVGTextRenderer.renderText(sVGTextElementImpl);
    }

    class DrawingInstruction {
        boolean stroke = false;
        boolean nonzero = false;
        boolean fill = false;
        int linecap = 0;
        int linejoin = 0;
        int miterwidth = 8;

        DrawingInstruction() {
        }
    }

    class SVGTextRenderer {
        FontState fs;
        String transstr;
        float currentX;
        float currentY;
        float baseX;
        float baseY;
        SVGMatrix matrix;
        float x;
        float y;

        SVGTextRenderer(FontState fontState, SVGTextElementImpl sVGTextElementImpl, float f, float f2) {
            this.fs = fontState;
            PDFNumber pDFNumber = new PDFNumber();
            SVGTransformList sVGTransformList = sVGTextElementImpl.getTransform().getBaseVal();
            this.matrix = sVGTransformList.consolidate().getMatrix();
            this.transstr = String.valueOf(pDFNumber.doubleOut(this.matrix.getA())) + " " + pDFNumber.doubleOut(this.matrix.getB()) + " " + pDFNumber.doubleOut(this.matrix.getC()) + " " + pDFNumber.doubleOut(-this.matrix.getD()) + " ";
            this.x = f;
            this.y = f2;
        }

        void renderText(SVGTextElementImpl sVGTextElementImpl) {
            DrawingInstruction drawingInstruction = SVGRenderer.this.applyStyle(sVGTextElementImpl, (SVGStylable)sVGTextElementImpl);
            if (drawingInstruction.fill) {
                if (drawingInstruction.stroke) {
                    SVGRenderer.this.currentStream.write("2 Tr\n");
                } else {
                    SVGRenderer.this.currentStream.write("0 Tr\n");
                }
            } else if (drawingInstruction.stroke) {
                SVGRenderer.this.currentStream.write("1 Tr\n");
            }
            this.updateFont((SVGStylable)sVGTextElementImpl, this.fs);
            float f = sVGTextElementImpl.x;
            float f2 = sVGTextElementImpl.y;
            this.currentX = this.x + f;
            this.currentY = this.y + f2;
            this.baseX = this.currentX;
            this.baseY = this.currentY;
            NodeList nodeList = sVGTextElementImpl.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Object object;
                boolean bl;
                Object object2;
                Node node = nodeList.item(n);
                SVGRenderer.this.applyStyle(sVGTextElementImpl, (SVGStylable)sVGTextElementImpl);
                if (node instanceof CharacterData) {
                    object2 = ((CharacterData)node).getData();
                    SVGRenderer.this.currentStream.write(String.valueOf(this.transstr) + (this.currentX + this.matrix.getE()) + " " + (this.baseY + this.matrix.getF()) + " Tm " + "(");
                    bl = "preserve".equals(sVGTextElementImpl.getXMLspace());
                    this.currentX = SVGRenderer.this.addSVGStr(this.fs, this.currentX, (String)object2, bl);
                    SVGRenderer.this.currentStream.write(") Tj\n");
                } else if (node instanceof SVGTextPathElementImpl) {
                    object2 = (SVGTextPathElementImpl)node;
                    String string = ((SVGTextPathElementImpl)object2).str;
                    object = null;
                    object = SVGRenderer.this.locateDef(string, (SVGElement)object2);
                } else if (node instanceof SVGTRefElementImpl) {
                    String string = ((SVGTRefElementImpl)object2).ref;
                    object2 = (SVGTRefElementImpl)node;
                    object = SVGRenderer.this.locateDef(string, (SVGElement)object2);
                    if (object instanceof SVGTextElementImpl) {
                        SVGTextElementImpl sVGTextElementImpl2 = (SVGTextElementImpl)object;
                        drawingInstruction = SVGRenderer.this.applyStyle((SVGElement)object2, (SVGStylable)object2);
                        if (drawingInstruction.fill) {
                            if (drawingInstruction.stroke) {
                                SVGRenderer.this.currentStream.write("2 Tr\n");
                            } else {
                                SVGRenderer.this.currentStream.write("0 Tr\n");
                            }
                        } else if (drawingInstruction.stroke) {
                            SVGRenderer.this.currentStream.write("1 Tr\n");
                        }
                        boolean bl2 = false;
                        FontState fontState = this.fs;
                        bl2 = this.updateFont((SVGStylable)sVGTextElementImpl, this.fs);
                        NodeList nodeList2 = sVGTextElementImpl2.getChildNodes();
                        boolean bl3 = "preserve".equals(((GraphicElement)object2).getXMLspace());
                        this.renderTextNodes(bl3, nodeList2, ((SVGTSpanElementImpl)object2).getX().getBaseVal(), ((SVGTSpanElementImpl)object2).getY().getBaseVal(), ((SVGTSpanElementImpl)object2).getDx().getBaseVal(), ((SVGTSpanElementImpl)object2).getDy().getBaseVal());
                        if (bl2) {
                            this.fs = fontState;
                            SVGRenderer.this.currentStream.write("/" + this.fs.getFontName() + " " + (float)this.fs.getFontSize() / 1000.0f + " Tf\n");
                        }
                    }
                } else if (node instanceof SVGTSpanElementImpl) {
                    object2 = (SVGTSpanElementImpl)node;
                    SVGRenderer.this.applyStyle((SVGElement)object2, (SVGStylable)object2);
                    bl = false;
                    object = this.fs;
                    bl = this.updateFont((SVGStylable)object2, this.fs);
                    boolean bl4 = "preserve".equals(((GraphicElement)object2).getXMLspace());
                    this.renderTextNodes(bl4, ((NodeImpl)object2).getChildNodes(), ((SVGTSpanElementImpl)object2).getX().getBaseVal(), ((SVGTSpanElementImpl)object2).getY().getBaseVal(), ((SVGTSpanElementImpl)object2).getDx().getBaseVal(), ((SVGTSpanElementImpl)object2).getDy().getBaseVal());
                    if (bl) {
                        this.fs = object;
                        SVGRenderer.this.currentStream.write("/" + this.fs.getFontName() + " " + (float)this.fs.getFontSize() / 1000.0f + " Tf\n");
                    }
                } else {
                    MessageHandler.errorln("Error: unknown text element " + node);
                }
                ++n;
            }
        }

        void renderTextNodes(boolean bl, NodeList nodeList, SVGLengthList sVGLengthList, SVGLengthList sVGLengthList2, SVGLengthList sVGLengthList3, SVGLengthList sVGLengthList4) {
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            float f = this.currentX;
            float f2 = this.currentY;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node = nodeList.item(n2);
                if (node instanceof CharacterData) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = ((CharacterData)node).getData();
                    int n3 = 0;
                    while (n3 < string.length()) {
                        char c = string.charAt(n3);
                        f = this.currentX;
                        f2 = this.currentY;
                        if (sVGLengthList2.getNumberOfItems() > n) {
                            f2 = this.baseY + ((Float)sVGLengthList2.getItem(n)).floatValue();
                        }
                        if (sVGLengthList4.getNumberOfItems() > n) {
                            f2 += ((Float)sVGLengthList4.getItem(n)).floatValue();
                        }
                        if (sVGLengthList.getNumberOfItems() > n) {
                            f = this.baseX + ((Float)sVGLengthList.getItem(n)).floatValue();
                        }
                        if (sVGLengthList3.getNumberOfItems() > n) {
                            f += ((Float)sVGLengthList3.getItem(n)).floatValue();
                        }
                        if (c > '\u007f') {
                            stringBuffer = stringBuffer.append(String.valueOf(this.transstr) + (f + this.matrix.getE()) + " " + (f2 + this.matrix.getF()) + " Tm " + "(" + "\\" + Integer.toOctalString(c) + ") Tj\n");
                            this.currentX = f + (float)this.fs.width(c) / 1000.0f;
                            this.currentY = f2;
                            ++n;
                            bl2 = true;
                            bl3 = false;
                        } else {
                            switch (c) {
                                case '(': {
                                    stringBuffer = stringBuffer.append(String.valueOf(this.transstr) + (f + this.matrix.getE()) + " " + (f2 + this.matrix.getF()) + " Tm " + "(" + "\\(" + ") Tj\n");
                                    this.currentX = f + (float)this.fs.width(c) / 1000.0f;
                                    this.currentY = f2;
                                    ++n;
                                    bl2 = true;
                                    bl3 = false;
                                    break;
                                }
                                case ')': {
                                    stringBuffer = stringBuffer.append(String.valueOf(this.transstr) + (f + this.matrix.getE()) + " " + (f2 + this.matrix.getF()) + " Tm " + "(" + "\\)" + ") Tj\n");
                                    this.currentX = f + (float)this.fs.width(c) / 1000.0f;
                                    this.currentY = f2;
                                    ++n;
                                    bl2 = true;
                                    bl3 = false;
                                    break;
                                }
                                case '\\': {
                                    stringBuffer = stringBuffer.append(String.valueOf(this.transstr) + (f + this.matrix.getE()) + " " + (f2 + this.matrix.getF()) + " Tm " + "(" + "\\\\" + ") Tj\n");
                                    this.currentX = f + (float)this.fs.width(c) / 1000.0f;
                                    this.currentY = f2;
                                    ++n;
                                    bl2 = true;
                                    bl3 = false;
                                    break;
                                }
                                case '\t': 
                                case ' ': {
                                    if (bl) {
                                        this.currentX = f + (float)this.fs.width(32) / 1000.0f;
                                        this.currentY = f2;
                                        ++n;
                                        break;
                                    }
                                    if (!bl2 || bl3) break;
                                    bl3 = true;
                                    this.currentX = f + (float)this.fs.width(32) / 1000.0f;
                                    this.currentY = f2;
                                    ++n;
                                    break;
                                }
                                case '\n': 
                                case '\r': {
                                    if (!bl) break;
                                    this.currentX = f + (float)this.fs.width(32) / 1000.0f;
                                    this.currentY = f2;
                                    ++n;
                                    break;
                                }
                                default: {
                                    bl3 = false;
                                    stringBuffer = stringBuffer.append(String.valueOf(this.transstr) + (f + this.matrix.getE()) + " " + (f2 + this.matrix.getF()) + " Tm " + "(" + c + ") Tj\n");
                                    this.currentX = f + (float)this.fs.width(c) / 1000.0f;
                                    this.currentY = f2;
                                    ++n;
                                    bl2 = true;
                                    break;
                                }
                            }
                        }
                        SVGRenderer.this.currentStream.write(stringBuffer.toString());
                        ++n3;
                    }
                }
                ++n2;
            }
        }

        protected boolean updateFont(SVGStylable sVGStylable, FontState fontState) {
            boolean bl = false;
            String string = fontState.getFontFamily();
            CSSValue cSSValue = sVGStylable.getPresentationAttribute("font-family");
            if (cSSValue != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19) {
                string = cSSValue.getCssText();
            }
            if (!string.equals(fontState.getFontFamily())) {
                bl = true;
            }
            String string2 = fontState.getFontStyle();
            cSSValue = sVGStylable.getPresentationAttribute("font-style");
            if (cSSValue != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19) {
                string2 = cSSValue.getCssText();
            }
            if (!string2.equals(fontState.getFontStyle())) {
                bl = true;
            }
            String string3 = fontState.getFontWeight();
            cSSValue = sVGStylable.getPresentationAttribute("font-weight");
            if (cSSValue != null && cSSValue.getValueType() == 1 && ((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 19) {
                string3 = cSSValue.getCssText();
            }
            if (!string3.equals(fontState.getFontWeight())) {
                bl = true;
            }
            float f = (float)fontState.getFontSize() / 1000.0f;
            cSSValue = sVGStylable.getPresentationAttribute("font-size");
            if (cSSValue != null && cSSValue.getValueType() == 1) {
                f = ((CSSPrimitiveValue)cSSValue).getFloatValue((short)9);
            }
            if ((float)fontState.getFontSize() / 1000.0f != f) {
                bl = true;
            }
            if (bl) {
                try {
                    fontState = new FontState(fontState.getFontInfo(), string, string2, string3, (int)(f * 1000.0f));
                }
                catch (Exception exception) {}
                this.fs = fontState;
                SVGRenderer.this.currentStream.write("/" + fontState.getFontName() + " " + f + " Tf\n");
            } else if (!SVGRenderer.this.currentFontName.equals(fontState.getFontName()) || SVGRenderer.this.currentFontSize != fontState.getFontSize()) {
                SVGRenderer.this.currentStream.write("/" + fontState.getFontName() + " " + fontState.getFontSize() / 1000 + " Tf\n");
            }
            return bl;
        }
    }
}

